%Update 2017-11-20, PDE1: MATLAB script M-file that solves the dimensionless version of 
%continuum model using irradiative depletion sdeplcoeff (tau-tilde)and surface diffusion 
%replenishment sroouttilde. Used to generate fig. 20 of paper in Beilstein J. Nanotechnol. 
%2015, 6, 1518-1540,Continuum models of focused electron beam induced processing,Milos Toth, Charlene Lobo, Vinzenz Friedli, Aleksandra Szkudlarek and Ivo Utke
%Please note the the model is only accurate for structures with low aspect ratio
global sroouttilde;
global sdeplcoeff;

% ----------Input paramters
% 1) Adsorbate parameters
s_a=1;             % sticking coefficient/sticking factor
F_a=10^4;          % molecular flux in 1/(nm^2s)
n_0=2.0;           % maximum adsorbate concentration mol/(nm^2)
sigma=0.013;       % net cross section in nm^2   
tau=100e-6;        % residence time in s
D_0=4e7;         % diffusion coefficient in nm^2/s 
V_a=0.2;        % volume of the deposited molecule fragment nm^3
% 2) Beam settings
FWHM=100;            % FWHM of beam in nm
f_0=1.2e8;         % electron flux at the center in 1/(nm^2s)
t_total=5e-3;          % exposure time in s
%Calculation of model parameters

tau_out=(s_a*F_a/n_0 + 1/tau)^(-1)    % effective residence time in s  
%Calculation of diemensionless parameters
sdeplcoeff=1+f_0*sigma*tau_out
sroouttilde=2*(D_0*tau_out)^0.5/FWHM

%Mesh (time and space) x-logartithmic scale x=log(2r/FWHM)
%                      t-in units of tau_out
Nt=2000;
Nx=4000;
t_end=log10(t_total/tau_out)
x = linspace(-6,4,Nx);
t = logspace(-6,t_end,Nt);
%Solve the PDE
m=0;
u = pdepe(0,@pde1,@initial1,@bc1,x,t);
rates;
%Drawing profile in from (-5;5)*FWHM/2
profile

plot(FWHM/2*r(1000:7000),tau_out*s_a*V_a*F_a*height(Nt,1000:7000)) 
xlabel('r in [nm]')
ylabel('height in [nm]')

