/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.toolbox.images.AbstractModeHandler;
import com.mathworks.toolbox.images.ImageScrollPane;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class ZoomOutModeHandler
extends AbstractModeHandler {
    public ZoomOutModeHandler(ImageScrollPane imageScrollPane) {
        super(imageScrollPane);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.zoomOnClick();
    }

    private void zoomOnClick() {
        double d = this.getScrollPane().getMagComboBox().findMagnification();
        double d2 = Math.max(ZoomOutModeHandler.findZoomOutMag(d), this.getScrollPane().findFitMag());
        this.getScrollPane().getMagComboBox().setMag(d2);
        this.getScrollPane().updateView(this.getMousePress(), d2);
    }

    private static double findTol(double d) {
        return 0.02 * d;
    }

    private static double findZoomOutMag(double d) {
        double d2 = Math.log(d) / Math.log(2.0);
        double d3 = Math.floor(d2);
        boolean bl = d - Math.pow(2.0, d3) < ZoomOutModeHandler.findTol(d);
        double d4 = bl ? d3 - 1.0 : d3;
        double d5 = Math.pow(2.0, d4);
        double d6 = d5 * 4.0 / 3.0;
        boolean bl2 = d2 <= 0.0 && d - d6 > ZoomOutModeHandler.findTol(d);
        return bl2 ? d6 : d5;
    }

    public void setCursor() {
        this.getScrollPane().getClient().setCursor(Cursor.getPredefinedCursor(1));
    }
}

