/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.desk.DTWindowActivator;
import com.mathworks.mwswing.desk.DTWindowCloser;
import com.mathworks.mwswing.desk.DTWindowRegistry;
import com.mathworks.toolbox.images.ImageScrollPane;
import com.mathworks.toolbox.images.cpselect.CPPanel;
import com.mathworks.toolbox.images.cpselect.CPScrollPane;
import com.mathworks.toolbox.images.cpselect.CPSelectPrefs;
import com.mathworks.toolbox.images.cpselect.CPVector;
import com.mathworks.toolbox.images.cpselect.ControlPoint;
import com.mathworks.toolbox.images.cpselect.ControlPointPair;
import com.mathworks.toolbox.images.cpselect.InputBasePanel;
import com.mathworks.toolbox.images.cpselect.LegendFrame;
import com.mathworks.toolbox.images.cpselect.SaveToWorkspace;
import com.mathworks.toolbox.images.cpselect.UpdateDetailListener;
import com.mathworks.toolbox.images.cpselect.UpdateOverviewListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ControlPointSelectionTool
extends MJFrame
implements DTWindowActivator,
DTWindowCloser {
    public static final int DELETE_INPUT = 10;
    public static final int DELETE_BASE = 11;
    public static final int DELETE_INPUT_AND_BASE = 12;
    private static final int INITIAL_DETAIL_SCALE_FACTOR = 4;
    private static final int INITIAL_OVERVIEW_SCALE_FACTOR = 1;
    private static final int NUMBER_OF_PANES = 4;
    private static int sNumberOfCPST;
    private static Matlab sMatlab;
    private ImageIcon fMatlabIcon;
    private CPScrollPane[] fPanes = new CPScrollPane[4];
    private MJToggleButton fDefaultModeButton;
    private MJToggleButton fAddPointModeButton;
    private MJToggleButton fAddPredictPointModeButton;
    private MJToggleButton fZoomInModeButton;
    private MJToggleButton fZoomOutModeButton;
    private MJToggleButton fPanModeButton;
    private static ResourceBundle fCPBundle;
    private static LegendFrame sLegendFrame;
    private int fMode = 10;
    private BufferedImage fBaseImage;
    private BufferedImage fInputImage;
    private InputBasePanel fDetail;
    private InputBasePanel fOverview;
    private String fBaseImageName;
    private String fInputImageName;
    private CPVector fInputPoints;
    private CPVector fBasePoints;
    private Vector fInputBasePairs;
    private int fActivePairId = -1;
    private MJMenuItem fSavePointsItem;
    private MJMenuItem fExitItem;
    private MJMenuItem fDeleteActivePairItem;
    private MJMenuItem fDeleteActiveInputPointItem;
    private MJMenuItem fDeleteActiveBasePointItem;
    private DeleteAction fDeleteActivePairAction;
    private DeleteAction fDeleteActiveInputPointAction;
    private DeleteAction fDeleteActiveBasePointAction;
    private MJCheckBoxMenuItem fLegendItem;
    private MJMenuItem fCPSelectHelpItem;
    private PairsChangeListener fPairsChangeListener;
    private SavePointsListener fSavePointsListener;
    private ExitListener fExitListener;
    private CPUndoableEditListener fCPUndoableEditListener;
    private JComponent fCPST;
    private UndoManager fUndo = new UndoManager();
    private UndoAction fUndoAction;
    private RedoAction fRedoAction;
    private boolean fNeedToSave;
    private UpdateDetailListener fBaseUpdateDetailListener;
    private UpdateDetailListener fInputUpdateDetailListener;
    private UpdateOverviewListener fBaseUpdateOverviewListener;
    private UpdateOverviewListener fInputUpdateOverviewListener;

    public ControlPointSelectionTool(String string, String string2, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.fCPST = (JComponent)this.getContentPane();
        if (++sNumberOfCPST == 1) {
            this.setTitle(fCPBundle.getString("frame.cpselect"));
        } else {
            this.setTitle(fCPBundle.getString("frame.cpselect") + " " + sNumberOfCPST);
        }
        this.setBounds(CPSelectPrefs.getCPSelectWindowBounds());
        this.setSize(CPSelectPrefs.getCPSelectWindowBounds().width, CPSelectPrefs.getCPSelectWindowBounds().height);
        this.setLocation(CPSelectPrefs.getCPSelectWindowBounds().x, CPSelectPrefs.getCPSelectWindowBounds().y);
        DTWindowRegistry.getInstance().addActivator((DTWindowActivator)this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ControlPointSelectionTool.this.fExitListener.actionPerformed(new ActionEvent(ControlPointSelectionTool.this.fSavePointsItem, 0, null));
            }

            public void windowOpened(WindowEvent windowEvent) {
                ControlPointSelectionTool.this.getDetail().initializeView(4);
                ControlPointSelectionTool.this.getOverview().initializeView(1);
            }
        });
        this.setNeedToSave(false);
        this.setInputPoints(new CPVector());
        this.setBasePoints(new CPVector());
        this.setInputBasePairs(new Vector());
        Container container = this.getContentPane();
        MJPanel mJPanel = new MJPanel();
        container.setLayout(new BorderLayout());
        CPPanel cPPanel = new CPPanel(this.getInputPoints());
        CPPanel cPPanel2 = new CPPanel(this.getBasePoints());
        CPPanel cPPanel3 = new CPPanel(this.getInputPoints());
        CPPanel cPPanel4 = new CPPanel(this.getBasePoints());
        cPPanel.setName("Input Detail Panel");
        cPPanel2.setName("Base Detail Panel");
        cPPanel3.setName("Input Overview Panel");
        cPPanel4.setName("Base Overview Panel");
        this.setDetail(new InputBasePanel((JComponent)((Object)cPPanel), (JComponent)((Object)cPPanel2), fCPBundle.getString("panel.detail")));
        this.setOverview(new InputBasePanel((JComponent)((Object)cPPanel3), (JComponent)((Object)cPPanel4), fCPBundle.getString("panel.overview")));
        this.setPanes();
        this.fInputUpdateDetailListener = new UpdateDetailListener(this.getDetail().getInputScrollPane(), this.getOverview().getInputScrollPane());
        this.fBaseUpdateDetailListener = new UpdateDetailListener(this.getDetail().getBaseScrollPane(), this.getOverview().getBaseScrollPane());
        this.fInputUpdateOverviewListener = new UpdateOverviewListener(this.getDetail().getInputScrollPane(), this.getOverview().getInputScrollPane());
        this.fBaseUpdateOverviewListener = new UpdateOverviewListener(this.getDetail().getBaseScrollPane(), this.getOverview().getBaseScrollPane());
        cPPanel3.setUpdateDetailListener(this.fInputUpdateDetailListener);
        cPPanel4.setUpdateDetailListener(this.fBaseUpdateDetailListener);
        cPPanel.setUpdateOverviewListener(this.fInputUpdateOverviewListener);
        cPPanel2.setUpdateOverviewListener(this.fBaseUpdateOverviewListener);
        this.enableAddPointMode();
        this.getDetail().getInputMagBox().setToolTipText(fCPBundle.getString("tooltip.input_mag_detail"));
        this.getDetail().getBaseMagBox().setToolTipText(fCPBundle.getString("tooltip.base_mag_detail"));
        this.getDetail().getLinkCheckBox().setToolTipText(fCPBundle.getString("tooltip.lock_ratio_detail"));
        this.getOverview().getInputMagBox().setToolTipText(fCPBundle.getString("tooltip.input_mag_overview"));
        this.getOverview().getBaseMagBox().setToolTipText(fCPBundle.getString("tooltip.base_mag_overview"));
        this.getOverview().getLinkCheckBox().setToolTipText(fCPBundle.getString("tooltip.lock_ratio_overview"));
        this.fDeleteActiveInputPointAction = new DeleteInputAction("menu.delete_active_input");
        this.fDeleteActiveBasePointAction = new DeleteBaseAction("menu.delete_active_base");
        this.fDeleteActivePairAction = new DeletePairAction("menu.delete_active_pair");
        this.fCPUndoableEditListener = new CPUndoableEditListener();
        ChangeActivePairAction changeActivePairAction = new ChangeActivePairAction("change_active_pair");
        NewControlPointAction newControlPointAction = new NewControlPointAction("new_control_point");
        this.fPairsChangeListener = new PairsChangeListener();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].addDeletePairActionListener((ActionListener)((Object)this.fDeleteActivePairAction));
            this.getPanes()[i].addCPUndoableEditListener(this.fCPUndoableEditListener);
            this.getPanes()[i].addChangeActivePairActionListener((ActionListener)((Object)changeActivePairAction));
            this.getPanes()[i].addNewControlPointActionListener((ActionListener)((Object)newControlPointAction));
            this.getPanes()[i].addPairsChangeListener(this.fPairsChangeListener);
        }
        this.initMenus();
        this.initToolBar();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        mJPanel.setLayout((LayoutManager)gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)((Object)this.getOverview()), mJPanel, gridBagConstraints, 0, 1, 1, 1);
        this.add((Component)((Object)this.getDetail()), mJPanel, gridBagConstraints, 0, 0, 1, 1);
        container.add((Component)mJPanel, "Center");
        this.setInputImage(bufferedImage);
        this.setBaseImage(bufferedImage2);
        this.setInputImageName(string);
        this.setBaseImageName(string2);
        this.addNotify();
        this.setVisible(true);
    }

    private void add(Component component, MJPanel mJPanel, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        mJPanel.add(component, (Object)gridBagConstraints);
    }

    private void setPanes() {
        this.fPanes[0] = this.getDetail().getInputScrollPane();
        this.fPanes[1] = this.getDetail().getBaseScrollPane();
        this.fPanes[2] = this.getOverview().getInputScrollPane();
        this.fPanes[3] = this.getOverview().getBaseScrollPane();
    }

    private CPScrollPane[] getPanes() {
        return this.fPanes;
    }

    private boolean matlabSuccess(int n) {
        return Matlab.getExecutionStatus((int)n) == 0;
    }

    private void initMenus() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        MJMenu mJMenu = new MJMenu(fCPBundle.getString("menu.file"));
        mJMenu.setMnemonic(70);
        MJMenu mJMenu2 = new MJMenu(fCPBundle.getString("menu.edit"));
        mJMenu2.setMnemonic(69);
        MJMenu mJMenu3 = new MJMenu(fCPBundle.getString("menu.view"));
        mJMenu3.setMnemonic(86);
        MJMenu mJMenu4 = new MJMenu(fCPBundle.getString("menu.help"));
        mJMenu4.setMnemonic(72);
        this.fSavePointsItem = new MJMenuItem(fCPBundle.getString("menu.save"));
        this.fSavePointsItem.setMnemonic(83);
        this.fSavePointsItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fSavePointsListener = new SavePointsListener();
        this.fSavePointsItem.addActionListener((ActionListener)this.fSavePointsListener);
        this.fExitItem = new MJMenuItem("Exit Control Point Selection Tool");
        this.fExitItem.setMnemonic(88);
        this.fExitListener = new ExitListener();
        this.fExitItem.addActionListener((ActionListener)this.fExitListener);
        this.fDeleteActivePairItem = new MJMenuItem(fCPBundle.getString("menu.delete_active_pair"));
        this.fDeleteActivePairItem.setEnabled(false);
        this.fDeleteActivePairItem.setMnemonic(68);
        this.fDeleteActivePairItem.addActionListener((ActionListener)((Object)this.fDeleteActivePairAction));
        this.fDeleteActiveInputPointItem = new MJMenuItem(fCPBundle.getString("menu.delete_active_input"));
        this.fDeleteActiveInputPointItem.setEnabled(false);
        this.fDeleteActiveInputPointItem.setMnemonic(87);
        this.fDeleteActiveInputPointItem.addActionListener((ActionListener)((Object)this.fDeleteActiveInputPointAction));
        this.fDeleteActiveBasePointItem = new MJMenuItem(fCPBundle.getString("menu.delete_active_base"));
        this.fDeleteActiveBasePointItem.setEnabled(false);
        this.fDeleteActiveBasePointItem.setMnemonic(87);
        this.fDeleteActiveBasePointItem.addActionListener((ActionListener)((Object)this.fDeleteActiveBasePointAction));
        this.fUndoAction = new UndoAction();
        this.fRedoAction = new RedoAction();
        MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(fCPBundle.getString("menu.overview_images"), true);
        mJCheckBoxMenuItem.setMnemonic(79);
        OverviewCheckBoxListener overviewCheckBoxListener = new OverviewCheckBoxListener((JComponent)((Object)this.getOverview()));
        mJCheckBoxMenuItem.addItemListener((ItemListener)overviewCheckBoxListener);
        this.fLegendItem = new MJCheckBoxMenuItem(fCPBundle.getString("menu.legend"), true);
        this.fLegendItem.setMnemonic(76);
        LegendCheckBoxListener legendCheckBoxListener = new LegendCheckBoxListener();
        this.fLegendItem.addItemListener((ItemListener)legendCheckBoxListener);
        LegendChangeListener legendChangeListener = new LegendChangeListener();
        sLegendFrame.addLegendCloseListener(legendChangeListener);
        this.fCPSelectHelpItem = new MJMenuItem(fCPBundle.getString("menu.cpst_help"));
        this.fCPSelectHelpItem.setMnemonic(67);
        this.fCPSelectHelpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sMatlab.fevalConsoleOutput("imuitoolsgate", new Object[]{"cpselecthelpjava"}, 0, (CompletionObserver)null);
            }
        });
        mJMenu3.add((JMenuItem)mJCheckBoxMenuItem);
        mJMenu3.add((JMenuItem)this.fLegendItem);
        mJMenu.add((JMenuItem)this.fSavePointsItem);
        mJMenu.add((JMenuItem)this.fExitItem);
        mJMenu2.add((Action)((Object)this.fUndoAction));
        mJMenu2.add((Action)((Object)this.fRedoAction));
        mJMenu2.addSeparator();
        mJMenu2.add((JMenuItem)this.fDeleteActivePairItem);
        mJMenu2.add((JMenuItem)this.fDeleteActiveInputPointItem);
        mJMenu2.add((JMenuItem)this.fDeleteActiveBasePointItem);
        mJMenu4.add((JMenuItem)this.fCPSelectHelpItem);
        mJMenuBar.add((JMenu)mJMenu);
        mJMenuBar.add((JMenu)mJMenu2);
        mJMenuBar.add((JMenu)mJMenu3);
        mJMenuBar.add((JMenu)mJMenu4);
        this.setJMenuBar((JMenuBar)mJMenuBar);
    }

    private void pairsChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePairsChangedEvent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ControlPointSelectionTool.this.firePairsChangedEvent();
                }
            });
        }
    }

    private void firePairsChangedEvent() {
        this.fPairsChangeListener.stateChanged(new ChangeEvent(""));
    }

    private void initToolBar() {
        MJToolBar mJToolBar = new MJToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        ImageIcon imageIcon = new ImageIcon(ImageScrollPane.class.getResource("resources/selecticon.gif"));
        ImageIcon imageIcon2 = new ImageIcon(ControlPointSelectionTool.class.getResource("resources/dot_hollow.gif"));
        ImageIcon imageIcon3 = new ImageIcon(ControlPointSelectionTool.class.getResource("resources/double_dot.gif"));
        ImageIcon imageIcon4 = new ImageIcon(ImageScrollPane.class.getResource("resources/glassplus.gif"));
        ImageIcon imageIcon5 = new ImageIcon(ImageScrollPane.class.getResource("resources/glassminus.gif"));
        ImageIcon imageIcon6 = new ImageIcon(ImageScrollPane.class.getResource("resources/hand.gif"));
        this.fDefaultModeButton = new MJToggleButton((Icon)imageIcon);
        this.fAddPointModeButton = new MJToggleButton((Icon)imageIcon2, true);
        this.fAddPredictPointModeButton = new MJToggleButton((Icon)imageIcon3);
        this.fZoomInModeButton = new MJToggleButton((Icon)imageIcon4);
        this.fZoomOutModeButton = new MJToggleButton((Icon)imageIcon5);
        this.fPanModeButton = new MJToggleButton((Icon)imageIcon6);
        this.fDefaultModeButton.setName("Default Mode Button");
        this.fAddPointModeButton.setName("Add Point Mode Button");
        this.fAddPredictPointModeButton.setName("Add Predict Point Mode Button");
        this.fZoomInModeButton.setName("Zoom In Mode Button");
        this.fZoomOutModeButton.setName("Zoom Out Mode Button");
        this.fPanModeButton.setName("Pan Mode Button");
        this.fDefaultModeButton.setToolTipText(fCPBundle.getString("tooltip.toolbar_default"));
        this.fAddPointModeButton.setToolTipText(fCPBundle.getString("tooltip.toolbar_add_points"));
        this.fAddPredictPointModeButton.setToolTipText(fCPBundle.getString("tooltip.toolbar_add_predict_points"));
        this.fZoomInModeButton.setToolTipText(fCPBundle.getString("tooltip.toolbar_zoom_in"));
        this.fZoomOutModeButton.setToolTipText(fCPBundle.getString("tooltip.toolbar_zoom_out"));
        this.fPanModeButton.setToolTipText(fCPBundle.getString("tooltip.toolbar_pan"));
        this.fAddPredictPointModeButton.setEnabled(false);
        MJToggleButton[] mJToggleButtonArray = new MJToggleButton[]{this.fDefaultModeButton, this.fAddPointModeButton, this.fAddPredictPointModeButton, this.fZoomInModeButton, this.fZoomOutModeButton, this.fPanModeButton};
        for (int i = 0; i < mJToggleButtonArray.length; ++i) {
            buttonGroup.add((AbstractButton)mJToggleButtonArray[i]);
            mJToolBar.add((Component)mJToggleButtonArray[i]);
        }
        this.fDefaultModeButton.addActionListener((ActionListener)new DefaultModeActionListener());
        this.fAddPointModeButton.addActionListener((ActionListener)new AddPointModeActionListener());
        this.fAddPredictPointModeButton.addActionListener((ActionListener)new AddPredictPointModeActionListener());
        this.fZoomInModeButton.addActionListener((ActionListener)new ZoomInModeActionListener());
        this.fZoomOutModeButton.addActionListener((ActionListener)new ZoomOutModeActionListener());
        this.fPanModeButton.addActionListener((ActionListener)new PanModeActionListener());
        this.getContentPane().add((Component)mJToolBar, "North");
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Image image = Toolkit.getDefaultToolkit().getImage("bldr_sp.jpg");
            Image image2 = Toolkit.getDefaultToolkit().getImage("bldr_tm3.jpg");
            BufferedImage bufferedImage = ControlPointSelectionTool.Image2BufImage(image);
            BufferedImage bufferedImage2 = ControlPointSelectionTool.Image2BufImage(image2);
            ControlPointSelectionTool controlPointSelectionTool = new ControlPointSelectionTool("input image", "base image", bufferedImage, bufferedImage2);
            controlPointSelectionTool.setSize(800, 600);
            controlPointSelectionTool.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static BufferedImage Image2BufImage(Image image) {
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void close() {
        this.dispose();
    }

    public void dispose() {
        this.disableOverviewRects();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].removeCurrentModeHandler();
        }
        Rectangle rectangle = new Rectangle();
        boolean bl = false;
        DTWindowRegistry.getInstance().removeActivator((DTWindowActivator)this);
        rectangle = this.getBounds();
        CPSelectPrefs.setCPSelectWindowBounds(rectangle);
        sMatlab.unregisterAll();
        sLegendFrame.setVisible(false);
        this.fInputImage.flush();
        this.fBaseImage.flush();
        this.fInputImage = null;
        this.fBaseImage = null;
        super.dispose();
    }

    public void setInputImage(BufferedImage bufferedImage) {
        this.fInputImage = bufferedImage;
        this.getDetail().setInputImage(this.fInputImage);
        this.getOverview().setInputImage(this.fInputImage);
        int n = this.fInputImage.getWidth(null);
        int n2 = this.fInputImage.getHeight(null);
        double d = 1.0 / (double)Math.min(n, n2);
        this.getDetail().getInputMagBox().setMinAllowableMag(d);
        this.getOverview().getInputMagBox().setMinAllowableMag(d);
    }

    public void setBaseImage(BufferedImage bufferedImage) {
        this.fBaseImage = bufferedImage;
        this.getDetail().setBaseImage(this.fBaseImage);
        this.getOverview().setBaseImage(this.fBaseImage);
        int n = this.fBaseImage.getWidth(null);
        int n2 = this.fBaseImage.getHeight(null);
        double d = 1.0 / (double)Math.min(n, n2);
        this.getDetail().getBaseMagBox().setMinAllowableMag(d);
        this.getOverview().getBaseMagBox().setMinAllowableMag(d);
    }

    private void setNeedToSave(boolean bl) {
        this.fNeedToSave = bl;
    }

    private boolean needToSave() {
        return this.fNeedToSave;
    }

    public void loadControlPoints(Vector vector, CPVector cPVector, CPVector cPVector2) {
        this.setInputBasePairs(vector);
        this.setInputPoints(cPVector);
        this.setBasePoints(cPVector2);
        this.getDetail().getInputScrollPane().setPoints(this.getInputPoints());
        this.getOverview().getInputScrollPane().setPoints(this.getInputPoints());
        this.getDetail().getBaseScrollPane().setPoints(this.getBasePoints());
        this.getOverview().getBaseScrollPane().setPoints(this.getBasePoints());
        this.pairsChanged();
    }

    public LegendFrame getLegendFrame() {
        return sLegendFrame;
    }

    private void setInputPoints(CPVector cPVector) {
        this.fInputPoints = cPVector;
    }

    private CPVector getInputPoints() {
        return this.fInputPoints;
    }

    private void setBasePoints(CPVector cPVector) {
        this.fBasePoints = cPVector;
    }

    private CPVector getBasePoints() {
        return this.fBasePoints;
    }

    private void setInputBasePairs(Vector vector) {
        this.fInputBasePairs = vector;
    }

    private Vector getInputBasePairs() {
        return this.fInputBasePairs;
    }

    private void setDetail(InputBasePanel inputBasePanel) {
        this.fDetail = inputBasePanel;
    }

    private void setOverview(InputBasePanel inputBasePanel) {
        this.fOverview = inputBasePanel;
    }

    public InputBasePanel getDetail() {
        return this.fDetail;
    }

    public InputBasePanel getOverview() {
        return this.fOverview;
    }

    public void activate() {
        this.toFront();
    }

    public String getShortTitle() {
        if (sNumberOfCPST == 1) {
            return fCPBundle.getString("frame.cpselect");
        }
        return fCPBundle.getString("frame.cpselect") + " " + sNumberOfCPST;
    }

    public String getGroupName() {
        return null;
    }

    public boolean canClose() {
        Object[] objectArray = new Object[]{"OK", "Cancel"};
        int n = MJOptionPane.showOptionDialog((Component)this.getContentPane(), (Object)fCPBundle.getString("dialog.exitMATLAB_text"), (String)fCPBundle.getString("dialog.title"), (int)2, (int)2, null, (Object[])objectArray, (Object)objectArray[1]);
        return n == 0;
    }

    public void setInputImageName(String string) {
        this.fInputImageName = string;
        this.getDetail().setInputLabelString(this.fInputImageName);
        this.getOverview().setInputLabelString(this.fInputImageName);
    }

    public void setBaseImageName(String string) {
        this.fBaseImageName = string;
        this.getDetail().setBaseLabelString(this.fBaseImageName);
        this.getOverview().setBaseLabelString(this.fBaseImageName);
    }

    public String getInputImageName() {
        return this.fInputImageName;
    }

    public String getBaseImageName() {
        return this.fBaseImageName;
    }

    private void enableOverviewRects() {
        this.getOverview().getInputScrollPane().getCPPanel().enableOverviewRect();
        this.getOverview().getBaseScrollPane().getCPPanel().enableOverviewRect();
    }

    private void disableOverviewRects() {
        this.getOverview().getInputScrollPane().getCPPanel().disableOverviewRect();
        this.getOverview().getBaseScrollPane().getCPPanel().disableOverviewRect();
    }

    private void enableDefaultMode() {
        this.fMode = 0;
        this.enableOverviewRects();
        this.fDetail.getInputScrollPane().makeCPDefaultModeCurrent();
        this.fDetail.getBaseScrollPane().makeCPDefaultModeCurrent();
        this.fOverview.getInputScrollPane().makeCPDefaultOverviewModeCurrent();
        this.fOverview.getBaseScrollPane().makeCPDefaultOverviewModeCurrent();
    }

    private void enableAddPointMode() {
        this.fMode = 10;
        this.disableOverviewRects();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].makeAddPointModeCurrent();
        }
    }

    private void enableAddPredictPointMode() {
        this.fMode = 11;
        this.disableOverviewRects();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].makeAddPredictPointModeCurrent();
        }
    }

    private void enablePanMode() {
        this.fMode = 3;
        this.disableOverviewRects();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].makePanModeCurrent();
        }
    }

    private void enableZoomInMode() {
        this.fMode = 1;
        this.disableOverviewRects();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].makeZoomInModeCurrent();
        }
    }

    private void enableZoomOutMode() {
        this.fMode = 2;
        this.disableOverviewRects();
        for (int i = 0; i < 4; ++i) {
            this.getPanes()[i].makeZoomOutModeCurrent();
        }
    }

    private void clearLastActivePair() {
        if (this.fActivePairId > -1) {
            ControlPointPair controlPointPair = (ControlPointPair)this.getInputBasePairs().elementAt(this.fActivePairId);
            controlPointPair.setActive(false);
        }
    }

    public ControlPointPair getActivePair() {
        ControlPointPair controlPointPair = null;
        if (this.fActivePairId > -1) {
            controlPointPair = (ControlPointPair)this.getInputBasePairs().elementAt(this.fActivePairId);
        }
        return controlPointPair;
    }

    private int savePoints() {
        String[] stringArray = new String[]{"Input points of valid pairs:", "Base points of valid pairs:", "Structure with all points:"};
        String[] stringArray2 = new String[]{"input_points", "base_points", "cpstruct"};
        boolean[] blArray = new boolean[]{true, true, false};
        int n = SaveToWorkspace.showSaveToWorkspace(fCPBundle.getString("menu.save"), stringArray, blArray, stringArray2, "cpsave", "imuitoolsgate", this.getInputBasePairs(), this.fCPST, false);
        return n;
    }

    private void doSave(final boolean bl) {
        final Runnable runnable = new Runnable(){

            public void run() {
                ControlPointSelectionTool.this.dispose();
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                int n = ControlPointSelectionTool.this.savePoints();
                if (n == 0) {
                    ControlPointSelectionTool.this.setNeedToSave(false);
                    if (bl) {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            }
        });
        thread.start();
    }

    static {
        sMatlab = new Matlab();
        fCPBundle = ResourceBundle.getBundle("com.mathworks.toolbox.images.resources.RES_CPSelect");
        sLegendFrame = new LegendFrame();
    }

    private class CPUndoableEditListener
    implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            ControlPointSelectionTool.this.fUndo.addEdit(undoableEditEvent.getEdit());
            ControlPointSelectionTool.this.fUndoAction.updateUndoState();
            ControlPointSelectionTool.this.fRedoAction.updateRedoState();
        }
    }

    class RedoAction
    extends MJAbstractAction {
        public RedoAction() {
            super(fCPBundle.getString("menu.redo"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ControlPointSelectionTool.this.fUndo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.updateRedoState();
            ControlPointSelectionTool.this.fUndoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (ControlPointSelectionTool.this.fUndo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", ControlPointSelectionTool.this.fUndo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", fCPBundle.getString("menu.redo"));
            }
        }
    }

    class UndoAction
    extends MJAbstractAction {
        public UndoAction() {
            super(fCPBundle.getString("menu.undo"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ControlPointSelectionTool.this.fUndo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.updateUndoState();
            ControlPointSelectionTool.this.fRedoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (ControlPointSelectionTool.this.fUndo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", ControlPointSelectionTool.this.fUndo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", fCPBundle.getString("menu.undo"));
            }
        }
    }

    private class OverviewCheckBoxListener
    implements ItemListener {
        private JComponent target;

        public OverviewCheckBoxListener(JComponent jComponent) {
            this.target = jComponent;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                this.target.setVisible(false);
                ControlPointSelectionTool.this.disableOverviewRects();
            } else {
                this.target.setVisible(true);
                ControlPointSelectionTool.this.enableOverviewRects();
            }
        }
    }

    private class PairsChangeListener
    implements ChangeListener {
        private PairsChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            for (int i = 0; i < 4; ++i) {
                ControlPointSelectionTool.this.getPanes()[i].getCPPanel().repaint();
            }
            ControlPointSelectionTool.this.setNeedToSave(true);
            ControlPointPair controlPointPair = ControlPointSelectionTool.this.getActivePair();
            if (controlPointPair != null) {
                if (controlPointPair.hasInputPoint()) {
                    ControlPointSelectionTool.this.fDeleteActiveInputPointItem.setEnabled(true);
                    ControlPointSelectionTool.this.fDeleteActiveInputPointAction.setEnabled(true);
                } else {
                    ControlPointSelectionTool.this.fDeleteActiveInputPointItem.setEnabled(false);
                    ControlPointSelectionTool.this.fDeleteActiveInputPointAction.setEnabled(false);
                }
                if (controlPointPair.hasBasePoint()) {
                    ControlPointSelectionTool.this.fDeleteActiveBasePointItem.setEnabled(true);
                    ControlPointSelectionTool.this.fDeleteActiveBasePointAction.setEnabled(true);
                } else {
                    ControlPointSelectionTool.this.fDeleteActiveBasePointItem.setEnabled(false);
                    ControlPointSelectionTool.this.fDeleteActiveBasePointAction.setEnabled(false);
                }
                if (controlPointPair.hasInputPoint() && controlPointPair.hasBasePoint()) {
                    ControlPointSelectionTool.this.fDeleteActivePairItem.setEnabled(true);
                    ControlPointSelectionTool.this.fDeleteActivePairAction.setEnabled(true);
                } else {
                    ControlPointSelectionTool.this.fDeleteActivePairItem.setEnabled(false);
                    ControlPointSelectionTool.this.fDeleteActivePairAction.setEnabled(false);
                }
            } else {
                ControlPointSelectionTool.this.fDeleteActivePairItem.setEnabled(false);
                ControlPointSelectionTool.this.fDeleteActiveInputPointItem.setEnabled(false);
                ControlPointSelectionTool.this.fDeleteActiveBasePointItem.setEnabled(false);
                ControlPointSelectionTool.this.fDeleteActivePairAction.setEnabled(false);
                ControlPointSelectionTool.this.fDeleteActiveInputPointAction.setEnabled(false);
                ControlPointSelectionTool.this.fDeleteActiveBasePointAction.setEnabled(false);
            }
            int n = 0;
            for (int i = 0; i < ControlPointSelectionTool.this.getInputBasePairs().size(); ++i) {
                ControlPointPair controlPointPair2 = (ControlPointPair)ControlPointSelectionTool.this.getInputBasePairs().elementAt(i);
                if (!controlPointPair2.hasInputPoint() || !controlPointPair2.hasBasePoint() || controlPointPair2.hasPredictedPoint()) continue;
                ++n;
            }
            if (n >= 2) {
                ControlPointSelectionTool.this.fAddPredictPointModeButton.setEnabled(true);
            } else {
                ControlPointSelectionTool.this.fAddPredictPointModeButton.setEnabled(false);
                if (ControlPointSelectionTool.this.fMode == 11) {
                    ControlPointSelectionTool.this.fAddPointModeButton.doClick();
                }
            }
        }
    }

    private class SavePointsListener
    implements ActionListener {
        private SavePointsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.doSave(false);
        }
    }

    private class ExitListener
    implements ActionListener {
        private ExitListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlPointSelectionTool.this.needToSave()) {
                int n = MJOptionPane.showConfirmDialog((Component)ControlPointSelectionTool.this.getContentPane(), (Object)fCPBundle.getString("dialog.exit_text"), (String)fCPBundle.getString("dialog.title"), (int)1, (int)2);
                if (n == 0) {
                    ControlPointSelectionTool.this.doSave(true);
                } else if (n == 1) {
                    ControlPointSelectionTool.this.dispose();
                }
            } else {
                ControlPointSelectionTool.this.dispose();
            }
        }
    }

    private class LegendCheckBoxListener
    implements ItemListener {
        private LegendCheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                sLegendFrame.setVisible(false);
            } else {
                sLegendFrame.setVisible(true);
            }
        }
    }

    private class LegendChangeListener
    implements ChangeListener {
        private LegendChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ControlPointSelectionTool.this.fLegendItem.setSelected(false);
        }
    }

    private class ZoomOutModeActionListener
    implements ActionListener {
        private ZoomOutModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.enableZoomOutMode();
        }
    }

    private class ZoomInModeActionListener
    implements ActionListener {
        private ZoomInModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.enableZoomInMode();
        }
    }

    private class PanModeActionListener
    implements ActionListener {
        private PanModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.enablePanMode();
        }
    }

    private class AddPredictPointModeActionListener
    implements ActionListener {
        private AddPredictPointModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.enableAddPredictPointMode();
        }
    }

    private class AddPointModeActionListener
    implements ActionListener {
        private AddPointModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.enableAddPointMode();
        }
    }

    private class DefaultModeActionListener
    implements ActionListener {
        private DefaultModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointSelectionTool.this.enableDefaultMode();
        }
    }

    private class PredictPoint
    implements Runnable {
        private ControlPoint fPick = null;

        public PredictPoint(ControlPoint controlPoint) {
            this.fPick = controlPoint;
        }

        public void run() {
            Object[] objectArray = new Object[]{"cppredictjava", ControlPointSelectionTool.this.getInputBasePairs(), ControlPointSelectionTool.this.getInputPoints(), ControlPointSelectionTool.this.getBasePoints(), this.fPick, ControlPointSelectionTool.this.fInputImage, ControlPointSelectionTool.this.fBaseImage};
            try {
                sMatlab;
                Matlab.mtFevalConsoleOutput((String)"imuitoolsgate", (Object[])objectArray, (int)0);
                ControlPointSelectionTool.this.pairsChanged();
            }
            catch (Exception exception) {
                System.out.println("cppredictjava failed");
                System.out.println(exception.getMessage());
            }
        }
    }

    private class NewControlPointAction
    extends MJAbstractAction {
        public NewControlPointAction(String string) {
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.addPoint((Vector)actionEvent.getSource());
        }

        private void addPoint(Vector vector) {
            boolean bl = false;
            boolean bl2 = false;
            if (vector.equals(ControlPointSelectionTool.this.getInputPoints())) {
                bl = true;
            } else if (vector.equals(ControlPointSelectionTool.this.getBasePoints())) {
                bl2 = true;
            } else {
                System.out.println("Something wrong in addPoint");
            }
            boolean bl3 = false;
            boolean bl4 = false;
            ControlPointPair controlPointPair = null;
            ControlPoint controlPoint = (ControlPoint)vector.lastElement();
            if (ControlPointSelectionTool.this.fActivePairId > -1) {
                controlPointPair = (ControlPointPair)ControlPointSelectionTool.this.getInputBasePairs().elementAt(ControlPointSelectionTool.this.fActivePairId);
                if (controlPointPair.isMatched()) {
                    bl4 = true;
                } else if (controlPointPair.hasBasePoint() && bl2 || controlPointPair.hasInputPoint() && bl) {
                    bl4 = true;
                } else {
                    bl3 = controlPointPair.hasBasePoint() && bl || controlPointPair.hasInputPoint() && bl2 ? true : true;
                }
            } else {
                bl4 = true;
            }
            if (bl3) {
                controlPoint.setPair(controlPointPair);
                if (bl) {
                    controlPointPair.setInputPoint(controlPoint);
                } else {
                    controlPointPair.setBasePoint(controlPoint);
                }
            }
            if (bl4) {
                controlPointPair = this.newPair(controlPoint, bl);
                controlPoint.setPair(controlPointPair);
                if (ControlPointSelectionTool.this.fMode == 11) {
                    if (Matlab.isMatlabAvailable()) {
                        sMatlab;
                        Matlab.whenMatlabReady((Runnable)new PredictPoint(controlPoint));
                    } else {
                        System.out.println("MATLAB is not available");
                    }
                }
            }
            ControlPointSelectionTool.this.pairsChanged();
        }

        private ControlPointPair newPair(ControlPoint controlPoint, boolean bl) {
            ControlPointSelectionTool.this.clearLastActivePair();
            ControlPointPair controlPointPair = new ControlPointPair(ControlPointSelectionTool.this.getInputBasePairs().size());
            controlPointPair.setActive(true);
            ControlPointSelectionTool.this.fActivePairId = controlPointPair.getPairId();
            ControlPointSelectionTool.this.getInputBasePairs().addElement(controlPointPair);
            if (bl) {
                controlPointPair.setInputPoint(controlPoint);
            } else {
                controlPointPair.setBasePoint(controlPoint);
            }
            return controlPointPair;
        }
    }

    private class ChangeActivePairAction
    extends MJAbstractAction {
        public ChangeActivePairAction(String string) {
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointPair controlPointPair = (ControlPointPair)actionEvent.getSource();
            ControlPointSelectionTool.this.clearLastActivePair();
            controlPointPair.setActive(true);
            ControlPointSelectionTool.this.fActivePairId = controlPointPair.getPairId();
            ControlPointSelectionTool.this.pairsChanged();
        }
    }

    private class DeleteActiveUndoableEdit
    extends AbstractUndoableEdit {
        ControlPoint pInput;
        ControlPoint pBase;
        ControlPointPair activePair;
        int deleteWhich;

        public DeleteActiveUndoableEdit(ControlPointPair controlPointPair, ControlPoint controlPoint, ControlPoint controlPoint2, int n) {
            this.activePair = controlPointPair;
            this.pInput = controlPoint;
            this.pBase = controlPoint2;
            this.deleteWhich = n;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.pInput != null) {
                ControlPointSelectionTool.this.getInputPoints().removeElement(this.pInput);
                this.activePair.setInputPoint(null);
            }
            if (this.pBase != null) {
                ControlPointSelectionTool.this.getBasePoints().removeElement(this.pBase);
                this.activePair.setBasePoint(null);
            }
            ControlPointSelectionTool.this.pairsChanged();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.pInput != null) {
                ControlPointSelectionTool.this.getInputPoints().addElement(this.pInput);
                this.activePair.setInputPoint(this.pInput);
            }
            if (this.pBase != null) {
                ControlPointSelectionTool.this.getBasePoints().addElement(this.pBase);
                this.activePair.setBasePoint(this.pBase);
            }
            ControlPointSelectionTool.this.pairsChanged();
        }

        public String getPresentationName() {
            return fCPBundle.getString("undo.delete");
        }
    }

    private class DeleteAction
    extends MJAbstractAction {
        private boolean fDeleteInput = false;
        private boolean fDeleteBase = false;

        public DeleteAction(String string) {
            this.putValue("Name", string);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlPointPair controlPointPair = ControlPointSelectionTool.this.getActivePair();
            if (controlPointPair != null) {
                ControlPoint controlPoint;
                ControlPoint controlPoint2 = controlPointPair.getInputPoint();
                if (controlPoint2 != null & this.deleteInput()) {
                    ControlPointSelectionTool.this.getInputPoints().removeElement(controlPoint2);
                    controlPointPair.setInputPoint(null);
                }
                if ((controlPoint = controlPointPair.getBasePoint()) != null & this.deleteBase()) {
                    ControlPointSelectionTool.this.getBasePoints().removeElement(controlPoint);
                    controlPointPair.setBasePoint(null);
                }
                if (controlPointPair.getInputPoint() == null & controlPointPair.getBasePoint() == null) {
                    ControlPointSelectionTool.this.fActivePairId = -1;
                    controlPointPair.setActive(false);
                }
                ControlPointSelectionTool.this.pairsChanged();
                DeleteActiveUndoableEdit deleteActiveUndoableEdit = new DeleteActiveUndoableEdit(controlPointPair, controlPoint2, controlPoint, 0);
                ControlPointSelectionTool.this.fCPUndoableEditListener.undoableEditHappened(new UndoableEditEvent((Object)this, deleteActiveUndoableEdit));
            }
        }

        protected void setDeleteInput(boolean bl) {
            this.fDeleteInput = bl;
        }

        protected void setDeleteBase(boolean bl) {
            this.fDeleteBase = bl;
        }

        protected boolean deleteInput() {
            return this.fDeleteInput;
        }

        protected boolean deleteBase() {
            return this.fDeleteBase;
        }
    }

    private class DeletePairAction
    extends DeleteAction {
        public DeletePairAction(String string) {
            super(string);
            this.setDeleteInput(true);
            this.setDeleteBase(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
        }
    }

    private class DeleteBaseAction
    extends DeleteAction {
        public DeleteBaseAction(String string) {
            super(string);
            this.setDeleteBase(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
        }
    }

    private class DeleteInputAction
    extends DeleteAction {
        public DeleteInputAction(String string) {
            super(string);
            this.setDeleteInput(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
        }
    }
}

