/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.toolbox.images.cpselect.MatchedCPSymbol;
import com.mathworks.toolbox.images.cpselect.PredictedCPSymbol;
import com.mathworks.toolbox.images.cpselect.UnmatchedCPSymbol;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class CPSymbol {
    private boolean fActive = false;
    private static int sDiameter = 15;
    protected static Color sFillColor = Color.green;
    protected static Color sOutlineColor = Color.black;
    static final CPSymbol UNMATCHED = new UnmatchedCPSymbol();
    static final CPSymbol MATCHED = new MatchedCPSymbol();
    static final CPSymbol PREDICTED = new PredictedCPSymbol();

    public abstract void paintMySymbol(Graphics2D var1, Point var2);

    public void paintSymbol(Graphics2D graphics2D, Point point, boolean bl) {
        this.paintMySymbol(graphics2D, point);
        if (bl) {
            this.paintBox(graphics2D, point);
        }
    }

    public boolean isActive() {
        return this.fActive;
    }

    public void setActive(boolean bl) {
        this.fActive = bl;
    }

    public static int getDiameter() {
        return sDiameter;
    }

    public static int getRadius() {
        return (CPSymbol.getDiameter() - 1) / 2;
    }

    private void paintBox(Graphics2D graphics2D, Point point) {
        int n = this.getXMin(point);
        int n2 = this.getYMin(point);
        graphics2D.setColor(sOutlineColor);
        graphics2D.drawRect(n, n2, sDiameter - 1, sDiameter - 1);
        graphics2D.setColor(sFillColor);
        graphics2D.drawRect(n - 1, n2 - 1, sDiameter + 1, sDiameter + 1);
    }

    protected void paintDonut(Graphics2D graphics2D, Point point) {
        int n = this.getXMin(point);
        int n2 = this.getYMin(point);
        graphics2D.setColor(sOutlineColor);
        graphics2D.drawOval(n, n2, sDiameter - 1, sDiameter - 1);
        graphics2D.setColor(sFillColor);
        graphics2D.drawOval(n + 1, n2 + 1, sDiameter - 3, sDiameter - 3);
        graphics2D.drawOval(n + 2, n2 + 2, sDiameter - 5, sDiameter - 5);
        graphics2D.setColor(sOutlineColor);
        graphics2D.drawOval(n + 3, n2 + 3, sDiameter - 7, sDiameter - 7);
    }

    protected void paintDot(Graphics2D graphics2D, Point point) {
        int n = this.getXMin(point);
        int n2 = this.getYMin(point);
        graphics2D.setColor(sOutlineColor);
        graphics2D.drawOval(n, n2, sDiameter - 1, sDiameter - 1);
        graphics2D.setColor(sFillColor);
        graphics2D.fillOval(n + 1, n2 + 1, sDiameter - 2, sDiameter - 2);
    }

    protected void paintCrosshair(Graphics2D graphics2D, Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = this.getXMin(point);
        int n4 = this.getYMin(point);
        int n5 = this.getXMax(point);
        int n6 = this.getYMax(point);
        graphics2D.setColor(sOutlineColor);
        graphics2D.drawLine(n3, n2, n5, n2);
        graphics2D.drawLine(n, n4, n, n6);
    }

    protected void paintP(Graphics2D graphics2D, Point point) {
        int n = point.x;
        int n2 = point.y;
        graphics2D.drawLine(n - 1, n2 - 4, n + 1, n2 - 4);
        graphics2D.drawLine(n - 1, n2, n + 1, n2);
        graphics2D.drawLine(n - 2, n2 - 4, n - 2, n2 + 4);
        graphics2D.drawLine(n + 2, n2 - 3, n + 2, n2 - 1);
    }

    public int getXMin(Point point) {
        return point.x - CPSymbol.getRadius();
    }

    public int getYMin(Point point) {
        return point.y - CPSymbol.getRadius();
    }

    public int getXMax(Point point) {
        return point.x + CPSymbol.getRadius();
    }

    public int getYMax(Point point) {
        return point.y + CPSymbol.getRadius();
    }
}

