/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.toolbox.images.AbstractModeHandler;
import com.mathworks.toolbox.images.ImagePanel;
import com.mathworks.toolbox.images.ImageScrollPane;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ZoomInModeHandler
extends AbstractModeHandler {
    public ZoomInModeHandler(ImageScrollPane imageScrollPane) {
        super(imageScrollPane);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        ImagePanel imagePanel = this.getScrollPane().getImPanel();
        Point2D point2D = imagePanel.toImageCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.dragZoomRect(point2D);
    }

    private void dragZoomRect(Point2D point2D) {
        double d = Math.min(this.getMousePress().getX(), point2D.getX());
        double d2 = Math.min(this.getMousePress().getY(), point2D.getY());
        double d3 = Math.max(this.getMousePress().getX(), point2D.getX());
        double d4 = Math.max(this.getMousePress().getY(), point2D.getY());
        double d5 = d3 - d;
        double d6 = d4 - d2;
        this.getScrollPane().getImPanel().setDragImageRect(new Rectangle2D.Double(d, d2, d5, d6));
        this.getScrollPane().getImPanel().repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ImagePanel imagePanel = this.getScrollPane().getImPanel();
        Point2D point2D = imagePanel.toImageCoordinates(mouseEvent.getX(), mouseEvent.getY());
        double d = Math.abs(this.getMousePress().getX() - point2D.getX());
        double d2 = Math.abs(this.getMousePress().getY() - point2D.getY());
        this.getScrollPane().getImPanel().setDragImageRect(null);
        if (d * d2 < 10.0) {
            this.zoomOnClick();
        } else {
            this.zoomOnDragRect(point2D, d, d2);
        }
    }

    private void zoomOnClick() {
        double d = this.getScrollPane().getMagComboBox().findMagnification();
        double d2 = ZoomInModeHandler.findZoomInMag(d);
        this.getScrollPane().getMagComboBox().setMag(d2);
        this.getScrollPane().updateView(this.getMousePress(), d2);
    }

    private void zoomOnDragRect(Point2D point2D, double d, double d2) {
        double d3 = this.getScrollPane().findScreenPerImagePixel(d, d2);
        double d4 = Math.min(this.getMousePress().getX(), point2D.getX()) + d / 2.0;
        double d5 = Math.min(this.getMousePress().getY(), point2D.getY()) + d2 / 2.0;
        Point2D.Double double_ = new Point2D.Double(d4, d5);
        this.getScrollPane().getMagComboBox().setMag(d3);
        this.getScrollPane().updateView((Point2D)double_, d3);
    }

    private static double findTol(double d) {
        return 0.02 * d;
    }

    private static double findZoomInMag(double d) {
        double d2 = Math.log(d) / Math.log(2.0);
        double d3 = Math.ceil(d2);
        boolean bl = Math.pow(2.0, d3) - d < ZoomInModeHandler.findTol(d);
        double d4 = bl ? d3 + 1.0 : d3;
        double d5 = Math.pow(2.0, d4);
        double d6 = d5 * 2.0 / 3.0;
        boolean bl2 = d2 < 0.0 && d6 - d > ZoomInModeHandler.findTol(d);
        return bl2 ? d6 : d5;
    }

    public void setCursor() {
        this.getScrollPane().getClient().setCursor(Cursor.getPredefinedCursor(1));
    }
}

