/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.toolbox.images.ImageScrollPane;
import com.mathworks.toolbox.images.MagnificationComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MagnificationComboBoxListener
implements PopupMenuListener,
ActionListener {
    private ImageScrollPane fScrollPane;

    public MagnificationComboBoxListener(ImageScrollPane imageScrollPane) {
        this.fScrollPane = imageScrollPane;
    }

    private ImageScrollPane getScrollPane() {
        return this.fScrollPane;
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        MagnificationComboBox magnificationComboBox = (MagnificationComboBox)((Object)popupMenuEvent.getSource());
        int n = magnificationComboBox.getSelectedIndex();
        if (n == 0) {
            double d = this.getScrollPane().findFitMag();
            magnificationComboBox.setMag(d);
            this.getScrollPane().updateView(d);
            magnificationComboBox.updateString();
        } else if (0 < n & n < magnificationComboBox.getItemCount()) {
            try {
                double d = magnificationComboBox.getSelectedScreenPerImagePixel(n);
                d = magnificationComboBox.findMinAllowableMag(d);
                magnificationComboBox.setMag(d);
                this.getScrollPane().updateView(d);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            this.parseEditBox(magnificationComboBox);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MagnificationComboBox magnificationComboBox = (MagnificationComboBox)((Object)actionEvent.getSource());
        if ("comboBoxEdited".equals(actionEvent.getActionCommand())) {
            this.parseEditBox(magnificationComboBox);
        }
    }

    private void parseEditBox(MagnificationComboBox magnificationComboBox) {
        boolean bl;
        double d = magnificationComboBox.findMagnification();
        boolean bl2 = bl = d != magnificationComboBox.getMag();
        if (bl) {
            magnificationComboBox.setMag(d);
            this.getScrollPane().updateView(d);
        } else {
            magnificationComboBox.updateString();
        }
    }
}

