/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.images.CoordinateConversion;
import com.mathworks.toolbox.images.DrawableRect;
import com.mathworks.toolbox.images.ImageScrollPane;
import com.mathworks.toolbox.images.util.ImageFactory;
import com.mathworks.toolbox.images.util.ImageResizer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImagePanel
extends MJPanel {
    private BufferedImage fBufImage = null;
    private BufferedImage fCachedImage = null;
    private ImageScrollPane fImScrollPane;
    private Rectangle2D fDragImageRect = null;
    private Rectangle2D fImageRect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle fScreenRect = new Rectangle(0, 0, 0, 0);
    private Rectangle fCachedScreenRect = new Rectangle(0, 0, 0, 0);

    private Rectangle getCachedScreenRect() {
        return this.fCachedScreenRect;
    }

    private void setCachedScreenRect(Rectangle rectangle) {
        this.fCachedScreenRect.setBounds(rectangle);
    }

    private BufferedImage getCachedImage() {
        return this.fCachedImage;
    }

    private void setCachedImage(BufferedImage bufferedImage) {
        this.fCachedImage = bufferedImage;
    }

    void setImScrollPane(ImageScrollPane imageScrollPane) {
        this.fImScrollPane = imageScrollPane;
    }

    ImageScrollPane getImScrollPane() {
        return this.fImScrollPane;
    }

    BufferedImage getBufImage() {
        return this.fBufImage;
    }

    public void setDragImageRect(Rectangle2D rectangle2D) {
        this.fDragImageRect = rectangle2D;
    }

    public Rectangle2D getDragImageRect() {
        return this.fDragImageRect;
    }

    private Rectangle getDragScreenRect() {
        return this.toScreenCoordinates(this.getDragImageRect());
    }

    public void setBufImage(BufferedImage bufferedImage) {
        this.fBufImage = bufferedImage;
    }

    public int getImageWidth() {
        return this.fBufImage.getWidth();
    }

    public int getImageHeight() {
        return this.fBufImage.getHeight();
    }

    public Point2D getVisibleCenterInImageCoords() {
        Rectangle2D rectangle2D = this.getImageRect();
        return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
    }

    double getScreenPerImagePixel() {
        return CoordinateConversion.getScreenPerImagePixel(this.getImageRect(), this.getScreenRect());
    }

    public Dimension getPreferredSize() {
        double d = this.getScreenPerImagePixel();
        return new Dimension((int)Math.floor(d * (double)this.getImageWidth()), (int)Math.floor(d * (double)this.getImageHeight()));
    }

    Dimension getOnScreenImageSize() {
        double d = this.getScreenPerImagePixel();
        return this.getOnScreenImageSize(d);
    }

    Dimension getOnScreenImageSize(double d) {
        return new Dimension((int)Math.round(d * (double)this.getImageWidth()), (int)Math.round(d * (double)this.getImageHeight()));
    }

    private double findVisImageDim(double d, int n, int n2) {
        double d2 = (double)n2 / d;
        return Math.min(d2, (double)n);
    }

    void setImageAndScreenRects(Point2D point2D, double d, Dimension dimension) {
        int n = this.getImageWidth();
        int n2 = this.getImageHeight();
        int n3 = dimension.width;
        int n4 = dimension.height;
        double d2 = this.findVisImageDim(d, n, n3);
        double d3 = this.findVisImageDim(d, n2, n4);
        Dimension dimension2 = this.getOnScreenImageSize(d);
        int n5 = Math.min(dimension2.width, n3);
        int n6 = Math.min(dimension2.height, n4);
        this.setImageRect(new Rectangle2D.Double(0.0, 0.0, d2, d3));
        this.setScreenRect(new Rectangle(0, 0, n5, n6));
        double d4 = this.findValidImTL(point2D.getX(), n, dimension2.width, n3, d2);
        double d5 = this.findValidImTL(point2D.getY(), n2, dimension2.height, n4, d3);
        this.setImageRect(new Rectangle2D.Double(d4, d5, d2, d3));
        int n7 = this.findValidScTL(d4, dimension2.width, n3);
        int n8 = this.findValidScTL(d5, dimension2.height, n4);
        this.setScreenRect(new Rectangle(n7, n8, n5, n6));
        boolean bl = dimension2.width < n3;
        boolean bl2 = dimension2.height < n4;
        this.setLocation(bl ? 0 : -this.getScreenRect().x, bl2 ? 0 : -this.getScreenRect().y);
    }

    private Point2D centerToTopLeft(double d, double d2, double d3, double d4) {
        return new Point2D.Double(d - d3 / 2.0, d2 - d4 / 2.0);
    }

    private double findValidImTL(double d, int n, int n2, int n3, double d2) {
        if (n2 <= n3) {
            return 0.0;
        }
        double d3 = this.getScreenPerImagePixel();
        double d4 = d - (double)Math.round((double)n3 / d3 / 2.0);
        double d5 = ImagePanel.clip(d4, n, d2);
        return d5;
    }

    private int findValidScTL(double d, int n, int n2) {
        boolean bl = n < n2;
        double d2 = bl ? (double)(n2 - n) / 2.0 : 0.0;
        return (int)Math.round(d * this.getScreenPerImagePixel() + d2);
    }

    Rectangle getScreenRect() {
        return this.fScreenRect;
    }

    public Rectangle2D getImageRect() {
        return this.fImageRect;
    }

    void setScreenRect(Rectangle rectangle) {
        this.fScreenRect = rectangle;
    }

    void setImageRect(Rectangle2D rectangle2D) {
        this.fImageRect = rectangle2D;
    }

    Rectangle toScreenCoordinates(Rectangle2D rectangle2D) {
        return CoordinateConversion.toScreenCoordinates(rectangle2D, this.getImageRect(), this.getScreenRect());
    }

    public Point toScreenCoordinates(Point2D point2D) {
        return CoordinateConversion.toScreenCoordinates(point2D.getX(), point2D.getY(), this.getImageRect(), this.getScreenRect());
    }

    public Point2D toImageCoordinates(int n, int n2) {
        return CoordinateConversion.toImageCoordinates(n, n2, this.getImageRect(), this.getScreenRect());
    }

    private static double clip(double d, int n, double d2) {
        double d3 = Math.max(d, 0.0);
        d3 = Math.min(d3, (double)n - d2);
        return d3;
    }

    private void drawDragRect(Graphics2D graphics2D) {
        if (this.getDragImageRect() != null) {
            DrawableRect.draw(this.getDragScreenRect(), graphics2D);
        }
    }

    void paintBackground(Graphics graphics) {
        super.paintComponent(graphics);
    }

    private void updateCachedImage() {
        boolean bl;
        Rectangle rectangle = this.getScreenRect();
        if (this.fBufImage == null || rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        boolean bl2 = bl = this.getCachedImage() == null || this.getCachedScreenRect().width != rectangle.width || this.getCachedScreenRect().height != rectangle.height;
        if (bl) {
            this.setCachedImage(ImageFactory.createSameTypeBufferedImage(this.fBufImage, rectangle.width, rectangle.height));
        }
        if (bl || !this.getCachedScreenRect().equals(rectangle)) {
            this.recomputeCachedImage();
        }
    }

    private void recomputeCachedImage() {
        ImageResizer.resize(this.fBufImage, this.getImageRect(), this.getCachedImage(), this.getScreenRect());
        this.setCachedScreenRect(this.getScreenRect());
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.fBufImage == null) {
            return;
        }
        Rectangle rectangle = this.getScreenRect();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D rectangle2D = this.getImageRect();
        Point point = this.getLocation();
        double d = this.getScreenPerImagePixel();
        Dimension dimension = this.getOnScreenImageSize(d);
        int n2 = dimension.width;
        int n3 = dimension.height;
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        boolean bl = n2 < this.getSize().width;
        boolean bl2 = n3 < this.getSize().height;
        int n4 = bl ? 0 : point.x + rectangle.x;
        int n5 = n = bl2 ? 0 : point.y + rectangle.y;
        if (n4 != 0 || n != 0) {
            double d4 = (double)n4 / d;
            double d5 = (double)n / d;
            rectangle.translate(-n4, -n);
            rectangle2D.setRect(rectangle2D.getX() - d4, rectangle2D.getY() - d5, d2, d3);
            double d6 = rectangle2D.getX();
            double d7 = rectangle2D.getY();
            d6 = ImagePanel.clip(d6, this.getImageWidth(), d2);
            d7 = ImagePanel.clip(d7, this.getImageHeight(), d3);
            rectangle2D.setRect(d6, d7, d2, d3);
            this.getImScrollPane().fireStateChanged();
        }
        super.paintComponent((Graphics)graphics2D);
        if (d2 != 0.0 && d3 != 0.0) {
            this.updateCachedImage();
            if (this.getCachedImage() != null) {
                graphics2D.drawImage((Image)this.getCachedImage(), rectangle.x, rectangle.y, null);
            }
            this.drawDragRect(graphics2D);
        }
    }
}

