// DataEvaluation.h: Function declaration
//

bool FileExists(string strFilename);

void ReadSimParam (char* pname, char* tmpstr, char* version, 
				   double tmpparam[], char paramnames[][256]);

void WriteStatisticsTube (char* pname, double TC, double MC, double UT, double BS, double TR, double TRH, double TR_LMC, 
						  double TR_LTC, double TR_DFT, double dif);

void WriteStatisticsSubstrate (char* pname, int config_num, double UT, double BS, double TR, double TRH,
							   valarray<double> LIS, valarray<double> LOS, valarray<double> DB, double dif);

void WriteStatisticsExport (char* pname, int config_num, double TC, double MC, double UT, double BS, 
							double TR, double TRH, double TR_LMC, double TR_LTC, double TR_DFT, valarray<double> LIS, 
							valarray<double> LOS, valarray<double> DB);

void WriteSummary (char* pname, char* tmpstr, char* version, double tmpparam[], char paramnames[][256], int lnum);

bool SubstrateMappingArray (valarray<double> &pos_substrate, 
							double imagesize, valarray< valarray< valarray<int> > > &mStrike, 
							int &index, int site[], bool &on_site);

void GetAngularDistribution (int &site_cnt, valarray<double> &dir_substrate, valarray< valarray<int> > &substrate_zenith,  
							 valarray< valarray<int> > &substrate_azimuth, int HistoRes, int LIF);

void UpdateDataContainers (char* pname, int config_num, valarray< valarray< valarray<int> > > &mStrike, 
						   valarray< valarray<int> > &substrate_zenith, valarray< valarray<int> > &substrate_azimuth, 
						   int virtual_no, double TRflux[], double BSflux[], double MFPsampling[], 
						   double MFPsectionCount[], double TubeCollCounter[], double CollisionCounter[], double &TC, 
						   double &MC, double &UT, double &BS, double &TR, double &TRH, double &TR_LMC, double &TR_LTC, 
						   double &TR_DFT, valarray<double> &LIS, valarray<double> &LOS, valarray<double> &DB);

void parse(double hilfs[], string parseString, string delimiter);

void MappingDataOutput (char* pname, int config_num, 
						valarray< valarray< valarray<int> > > &mStrike, 
						double imagesize, int mSize_x, int mSize_y, double TR);

void MappingAngularDistribution (char* pname, valarray< valarray<int> > &substrate_zenith, 
								 valarray< valarray<int> > &substrate_azimuth, int HistoRes);

void MappingPressureDataOutput (char* pname, double virtual_pos[], int virtual_no,
								double TRflux[], double BSflux[], 
								double TR, double TRH, double BS, double UT, double MFPsampling[], double MFPsectionCount[],
								double TubeCollCounter[], double CollisionCounter[]);

void GetConfigurationPlotData(char* pname, double imagesize, 
							  double planecenter, double planetilt, 
							  double alpha1Array[], double alpha2Array[], double distArray[], 
							  int config_num, bool hole, 
							  double r_hole, double z_hole, 
							  double tilt_hole, double r_a);

void GetTubeSurfaceDistribution (valarray<double> &pos, double TubeCollCounter[], int virtual_no, double planecenter, 
								 double planetilt);

void GetCollisionDistribution (valarray<double> &pos, double CollisionCounter[], int virtual_no, double planecenter, 
							   double planetilt);

					