// DataEvaluation.cpp: Function definition
//

#include "Includes.h"
#include "Modules.h"

const double pi = 3.1415926535897932385;

bool FileExists(string strFilename) {
	struct stat stFileInfo;
	bool blnReturn;
	int intStat;

	// Attempt to get the file attributes
	intStat = stat(strFilename.c_str(),&stFileInfo);
	if(intStat == 0) {
		// We were able to get the file attributes so the file obviously exists.
		blnReturn = true;
	}
	else {
		// We were not able to get the file attributes. This may mean that we don't have permission to
		// access the folder which contains this file. If you need to do that level of checking, lookup the
		// return values of stat which will give you more details on why stat failed.
		blnReturn = false;
	}
	return(blnReturn);
}

void ReadSimParam (char* pname, char* tmpstr, char* version, double tmpparam[], char paramnames[][256]) {

	char temp[256];
	char dummyline[256];

	ifstream InFile("./../../SimulationParameters/parameters.txt");
	InFile.precision(12);

	InFile.getline (pname, 256);
	InFile.getline (version, 256);
	InFile.getline (tmpstr, 256);
	InFile.getline (dummyline, 256);

	int i = 0;
	while(!InFile.getline(temp, 256).eof()) {
		if (i%2 != 0) {
			tmpparam[i/2] = strtod(temp, 0);
		}
		else {
			strcpy (paramnames[i/2], temp);
		}
		i++;
	}
	InFile.close();
}


bool SubstrateMappingArray (valarray<double> &pos_substrate, double imagesize, valarray< valarray< valarray<int> > > &mStrike, int &index, int site[], bool &on_site) {

	bool checkit = false;

	if (abs(pos_substrate[2]) < 1e-12) pos_substrate[2] = 0;

	if (pos_substrate[2] == 0) {

		int I_y = floor(mStrike[0].size()*(pos_substrate[0]+imagesize/2)/imagesize);

		if (I_y < mStrike[0].size()) {
			int I_x = floor(mStrike[0][I_y].size()*(pos_substrate[1]+imagesize/2)/imagesize);

			if (I_x < mStrike[0][I_y].size()) {
				checkit = true;
				(mStrike[index][I_x][I_y])++;

				unsigned int neighbours = site[2]/2;
				if (I_x >= site[0]-neighbours && I_x <= site[0]+neighbours && I_y >= site[1]-neighbours && I_y <= site[1]+neighbours) {
					on_site = true;
				}
				else on_site = false;
			}
		}
	}
	return checkit;
}


void GetTubeSurfaceDistribution (valarray<double> &pos, double TubeCollCounter[], int virtual_no, double planecenter, double planetilt) {

/* memory access problem???
	int Ind_tmp = floor((pos[2]/planecenter-tan(degree2rad(planetilt)))*virtual_no);
	if (Ind_tmp < virtual_no) TubeCollCounter[Ind_tmp]++;
	else cout << "err in GetTubeSurfaceDistribution" << endl;
*/
}

void GetCollisionDistribution (valarray<double> &pos, double CollisionCounter[], int virtual_no, double planecenter, double planetilt) {
/* memory access problem???
	int Ind_tmp = floor((pos[2]/planecenter-tan(degree2rad(planetilt)))*virtual_no);
	if (Ind_tmp < virtual_no) CollisionCounter[Ind_tmp]++;
	else cout << "err in GetCollisionDistribution" << endl;
*/
}


void GetAngularDistribution (int &site_cnt, valarray<double> &dir_substrate, valarray< valarray<int> > &substrate_zenith, valarray< valarray<int> > &substrate_azimuth, int HistoRes, int LIF) {

	site_cnt++;

	//histogram of angles into a solid angle
	int ind_zenith = floor(acos(-dir_substrate[2])*180/pi/HistoRes);
	substrate_zenith[LIF][ind_zenith]++;

	//histogram of angles subjected between incident molecule trajectory projected to y-x plane and the x axis
	int ind_azimuth = floor(acos(dir_substrate[0]/sqrt(dir_substrate[0]*dir_substrate[0]+dir_substrate[1]*dir_substrate[1]))*180/pi/HistoRes);
	if (dir_substrate[1]<0) ind_azimuth = (360/HistoRes-1)-ind_azimuth;
	substrate_azimuth[LIF][ind_azimuth]++;
}

template <typename T>
bool strtod_(T &aValue, const string &aStr)
{
	stringstream ss(aStr);
	return ss >> aValue;
}

void parse(double hilfs[], string parseString, string delimiter) {

	string value;
	int startPos = 0, pos = parseString.find(delimiter);
	int i = 0;
	while (pos != string::npos) {

		value = parseString.substr(startPos, pos - startPos);
		strtod_(hilfs[i], value);
		startPos = pos + delimiter.length();
		pos = parseString.find(delimiter, startPos);
		i++;
	}
	value = parseString.substr(startPos, parseString.length() - startPos);
}


void UpdateDataContainers (char* pname, int config_num, valarray< valarray< valarray<int> > > &mStrike,
						   valarray< valarray<int> > &substrate_zenith, valarray< valarray<int> > &substrate_azimuth,
						   int virtual_no, double TRflux[], double BSflux[], double MFPsampling[],
						   double MFPsectionCount[], double TubeCollCounter[], double CollisionCounter[], double &TC,
						   double &MC, double &UT, double &BS, double &TR, double &TRH, double &TR_LMC, double &TR_LTC,
						   double &TR_DFT, valarray<double> &LIS, valarray<double> &LOS, valarray<double> &DB) {

	// update mStrike
	double *hilfs = new double[mStrike[0].size()];
	char fname[256];
	string temp;

	for (int i=0; i < config_num; i++) {

		strcpy (fname, pname);

		char i_str[10];
		sprintf(i_str, "%d", i+1);
		strcat (fname, "Image_Config");
		strcat (fname, i_str);
		strcat (fname, ".txt");

		ifstream InFile(fname);
		InFile.precision(12);

		int index = i;

		for (unsigned int k = 0; k < mStrike[index].size(); k++) {
			getline(InFile, temp);
			parse(hilfs, temp, "\t");
			for (unsigned int l = 0; l < mStrike[index][k].size(); l++) {
				mStrike[index][k][l] = hilfs[l];
			}
		}
		InFile.close ();
	}
	delete[] hilfs;

	// update TC, MC, UT, BS, TR, TRH, TR_LMC, TR_LTC, TR_DFT, LIS, LOS, DB
	double *hilfs2 = new double[13];

	for (int i=0; i < config_num; i++) {

		strcpy (fname, pname);

		char i_str[10];
		sprintf(i_str, "%d", i+1);
		strcat (fname, "Statistics_export_Config");
		strcat (fname, i_str);
		strcat (fname, ".txt");

		ifstream InFile (fname);
		InFile.precision (12);

		int index = i;

		getline (InFile, temp);
		getline (InFile, temp);
		parse(hilfs2, temp, " ");

		TR = hilfs2[0];
		TRH = hilfs2[1];
		BS = hilfs2[2];
		UT = hilfs2[3];
		TC = hilfs2[4];
		MC = hilfs2[5];
		LIS[index] = hilfs2[7];
		LOS[index] = hilfs2[8];
		TR_LMC = hilfs2[9];
		TR_LTC = hilfs2[10];
		TR_DFT = hilfs2[11];
		DB[index] = hilfs2[12];

		InFile.close ();
	}
	delete[] hilfs2;

	//update substrate_zenith, substrate_azimuth
	double *hilfs3 = new double[9];

	strcpy (fname, pname);
	strcat (fname, "AngularDistributionHistogram.txt");
	ifstream InFile(fname);
	InFile.precision(6);

	getline (InFile, temp);
	for (int i = 0; i < substrate_zenith[0].size(); i++) {

		getline(InFile, temp);
		parse(hilfs3, temp, " ");

		substrate_zenith[0][i] = hilfs3[1];
		substrate_azimuth[0][i] = hilfs3[2];
		substrate_zenith[1][i] = hilfs3[3];
		substrate_azimuth[1][i] = hilfs3[4];
		substrate_zenith[2][i] = hilfs3[5];
		substrate_azimuth[2][i] = hilfs3[6];
	}

	InFile.close();

	delete[] hilfs3;

	//update TRflux, BSflux, MFPsampling, MFPsectionCount, TubeCollCounter, CollisionCounter
	double *hilfs4 = new double[9];

	strcpy (fname, pname);
	strcat (fname, "PressureDistribution.txt");
	ifstream InFile2 (fname);
	InFile2.precision(6);

	getline (InFile2, temp);
	for (int i = 0; i < virtual_no; i++) {

		getline (InFile2, temp);
		parse (hilfs4, temp, " ");

		//virtual_pos[i] = hilfs4[0];
		TRflux[i] = hilfs4[1];
		BSflux[i] = hilfs4[2];
		//netflux[i] = hilfs4[3];
		//BSfluxNorm[i] = hilfs4[4];
		//MFPsamplingNorm[i] = hilfs4[5];
		MFPsectionCount[i] = hilfs4[6];
		TubeCollCounter[i] = hilfs4[7];
		CollisionCounter[i] = hilfs4[8];
	}
	TRflux[0] = 0;

	InFile2.close();

	delete[] hilfs4;

}

void MappingDataOutput (char* pname, int config_num, valarray< valarray< valarray<int> > > &mStrike, double imagesize, int mSize_x, int mSize_y, double TR) {

	char fname[256];

	for (int i=0; i < config_num; i++) {

		strcpy (fname, pname);

		char i_str[10];
		sprintf(i_str, "%d", i+1);
		strcat (fname, "Image_Config");
		strcat (fname, i_str);
		strcat (fname, ".txt");
		cout << fname << endl;

		ofstream OutFile(fname);
		OutFile.precision(3);

		int index = i;

		for (unsigned int k = 0; k<mStrike[index].size(); k++) {
			for (unsigned int l = 0; l<mStrike[index][k].size(); l++) {
				OutFile << mStrike [index][k][l] << "\t";
			}
			OutFile << endl;
		}
		OutFile.close();
	}

	for (int i=0; i < config_num; i++) {

		strcpy (fname, pname);

		char i_str[10];
		sprintf(i_str, "%d", i+1);
		strcat (fname, "Profiles_Config");
		strcat (fname, i_str);
		strcat (fname, ".txt");
		cout << fname << endl;

		ofstream OutFile(fname);
		OutFile.precision(3);

		int index = i;

		double tmp;
		int ind = floor( (double) mStrike[index].size()/2);
		OutFile << "Position Counts CountsCoeff Sterr SterrRel FluxCoeff" << endl;
		for (unsigned int l = 0; l<mStrike[index].size(); l++) {
			//calculate the standard error on the counts coefficient
			tmp = sqrt(1/TR*((mStrike [index][ind][l]/TR)-(mStrike [index][ind][l]/TR)*(mStrike [index][ind][l]/TR)));
			OutFile << (double(l)-double(mStrike[index].size()-1)/2)/(mStrike[index].size()-1)*imagesize << " "
				<< mStrike [index][ind][l] << " "
				<< mStrike [index][ind][l]/TR << " "
				<< tmp;
			if (mStrike [index][ind][l] > 0) {
				OutFile << " " << 100/(mStrike [index][ind][l]/TR)*tmp << " ";
			}
			else OutFile << " " << 0 << " ";
			OutFile << mStrike [index][ind][l]/TR*pi*(mSize_x/imagesize)*(mSize_y/imagesize) << endl;

		}

		OutFile.close();

	}
}

void WriteSummary (char* pname, char* tmpstr, char* version, double tmpparam[], char paramnames[][256], int lnum) {

	ofstream OutFile;
	char fname[256];
	strcpy (fname, pname);

	strcat (fname, "Simulation_Summary.txt"); OutFile.open(fname);

	cout << "Summary of simulation parameters saved to:" << endl;
	cout << fname << endl;

	OutFile.precision(6);

	time_t rawtime;
	struct tm * timeinfo;
	time (&rawtime);
	timeinfo = localtime (&rawtime);
	OutFile << "SIMULATION finished on " << asctime (timeinfo)<< endl;
	OutFile << "Path: " << pname << endl;
	OutFile << "Version: " << version << endl;
	OutFile << "Comment: " << tmpstr << endl << endl;

	for (int i = 0; i<lnum; i++) {
		OutFile << paramnames[i] << endl;
		OutFile << tmpparam[i] <<  endl;
	}

	OutFile.close();
}


void WriteStatisticsTube (char* pname, double TC, double MC, double UT, double BS, double TR, double TRH, double TR_LMC,
						  double TR_LTC, double TR_DFT, double dif) {

	ofstream OutFile;
	char fname[256];
	strcpy (fname, pname);

	double MolNum = TR + TRH + BS + UT;
	double tmp;

	strcat (fname, "Statistics_Tube.txt"); OutFile.open(fname);
	cout << fname << endl;
	strcpy (fname, pname);
	OutFile.precision(6);

	OutFile << "STATISTICS INSIDE THE TUBE" << endl << endl;
	OutFile << "Elapsed Time = " << dif << " sec" << endl << endl;

	OutFile << "TR: " << TR << endl;
	OutFile << "TRH: " << TRH << endl;
	OutFile << "BS: " << BS << endl;
	OutFile << "UT: " << UT << endl;
	OutFile << "TC: " << TC << endl;
	OutFile << "MC: " << MC << endl;
	OutFile << "MolNum: " << MolNum << endl;
	OutFile << "TR_LMC: " << TR_LMC << endl;
	OutFile << "TR_LTC: " << TR_LTC << endl;
	OutFile << "TR_DFT: " << TR_DFT << endl << endl;

	OutFile << "Number of molecules computed = " << MolNum << endl;
	OutFile << "Transmission Coefficient = " << TR/MolNum;
	if (TR > 0) {
		tmp = sqrt(1/MolNum*(TR/MolNum-(TR/MolNum)*(TR/MolNum)));
		OutFile << " ste " << tmp << " (" << 100/(TR/MolNum)*tmp << "%)" << endl;
	}
	else OutFile << endl;
	OutFile << "Transmission through hole Coefficient = " << TRH/MolNum;
	if (TRH > 0) {
		tmp = sqrt(1/MolNum*(TRH/MolNum-(TRH/MolNum)*(TRH/MolNum)));
		OutFile << " ste " << tmp << " (" << 100/(TRH/MolNum)*tmp << "%)" << endl;
	}
	else OutFile << endl;
	OutFile << "Backscatter Coefficient = " << BS/MolNum;
	if (BS > 0) {
		tmp = sqrt(1/MolNum*(BS/MolNum-(BS/MolNum)*(BS/MolNum)));
		OutFile << " ste " << tmp << " (" << 100/(BS/MolNum)*tmp << "%)" << endl;
	}
	else OutFile << endl;
	OutFile << "Uptake Coefficient = " << UT/MolNum;
	if (UT > 0) {
		tmp = sqrt(1/MolNum*(UT/MolNum-(UT/MolNum)*(UT/MolNum)));
		OutFile << " ste " << tmp << " (" << 100/(UT/MolNum)*tmp << "%)" << endl;
	}
	else OutFile << endl;
	OutFile << "Mean tube collisions per molecule = " << TC/MolNum << endl;
	OutFile << "Mean molecule collision per molecule = " << MC/MolNum << endl << endl;

	OutFile << "STATISTICS AT TUBE EXIT" << endl;
	OutFile << "Number of molecules transmitted = " << TR << endl;
	OutFile << "LMC Coefficient = " << TR_LMC/TR;
	if (TR_LMC > 0) {
		tmp = sqrt(1/TR*(TR_LMC/TR-(TR_LMC/TR)*(TR_LMC/TR)));
		OutFile << " ste " << tmp << " (" << 100/(TR_LMC/TR)*tmp << "%)" << endl;
	}
	else OutFile << endl;
	OutFile << "LTC Coefficient = " << TR_LTC/TR;
	if (TR_LTC > 0) {
		tmp = sqrt(1/TR*(TR_LTC/TR-(TR_LTC/TR)*(TR_LTC/TR)));
		OutFile << " ste " << tmp << " (" << 100/(TR_LTC/TR)*tmp << "%)" << endl;
	}
	else OutFile << endl;
	OutFile << "DFT Coefficient = " << TR_DFT/TR;
	if (TR_DFT > 0) {
		tmp = sqrt(1/TR*(TR_DFT/TR-(TR_DFT/TR)*(TR_DFT/TR)));
		OutFile << " ste " << tmp << " (" << 100/(TR_DFT/TR)*tmp << "%)" << endl << endl;
	}
	else OutFile << endl << endl;

	OutFile.close();

}

void WriteStatisticsSubstrate (char* pname, int config_num, double UT, double BS, double TR, double TRH,
							   valarray<double> LIS, valarray<double> LOS, valarray<double> DB, double dif) {


	char fname[256];
	double MolNum = TR + TRH + BS + UT;
	double tmp;

	for (int i=0; i < config_num; i++) {

		strcpy (fname, pname);

		char i_str[10];
		sprintf(i_str, "%d", i+1);
		strcat (fname, "Statistics_Substrate_Config");
		strcat (fname, i_str);
		strcat (fname, ".txt");
		cout << fname << endl;

		ofstream OutFile(fname);
		OutFile.precision(6);

		int index = i;

		OutFile << "STATISTICS ON THE SUBSTRATE" << endl << endl;
		OutFile << "Elapsed Time = " << dif << " sec" << endl << endl;

		OutFile << "LIS: " << LIS[index] << endl;
		OutFile << "LOS: " << LOS[index] << endl;
		OutFile << "DB: " << DB[index] << endl << endl;

		OutFile << "Number of molecules arrived in the mapped zone = " << TR - LIS[index] - LOS[index] << endl;
		OutFile << "LIS Coefficient = " << LIS[index]/TR;
		if (LIS[index] > 0) {
			tmp = sqrt(1/TR*(LIS[index]/TR-(LIS[index]/TR)*(LIS[index]/TR)));
			OutFile << " ste " << tmp << " (" << 100/(LIS[index]/TR)*tmp << "%)" << endl;
		}
		else OutFile << endl;
		OutFile << "LOS Coefficient = " << LOS[index]/TR;
		if (LOS[index] > 0) {
			tmp = sqrt(1/TR*(LOS[index]/TR-(LOS[index]/TR)*(LOS[index]/TR)));
			OutFile << " ste " << tmp << " (" << 100/(LOS[index]/TR)*tmp << "%)" << endl << endl;
		}
		else OutFile << endl << endl;

		OutFile << "Percentage of substrate-molecules which desorbe back into the tube = " << DB[index]/TR*100 << "%" << endl;


		OutFile.close();
	}
}

void WriteStatisticsExport (char* pname, int config_num, double TC, double MC, double UT, double BS,
							double TR, double TRH, double TR_LMC, double TR_LTC, double TR_DFT, valarray<double> LIS,
							valarray<double> LOS, valarray<double> DB) {

	char fname[256];
	double MolNum = TR + TRH + BS + UT;


	// Writes a text file which is read by the GUI

	for (int i=0; i < config_num; i++) {

		strcpy (fname, pname);

		char i_str[10];
		sprintf(i_str, "%d", i+1);
		strcat (fname, "Statistics_export_Config");
		strcat (fname, i_str);
		strcat (fname, ".txt");
		cout << fname << endl;

		ofstream OutFile(fname);
		OutFile.precision(6);

		int index = i;

		OutFile << "STATISTICS OF THE SIMULATION" << endl;
		OutFile << TR << " " << TRH << " " << BS << " " << UT << " " << TC << " " << MC << " " << MolNum << " " << LIS[index] << " " << LOS[index] << " " << TR_LMC << " " << TR_LTC << " " << TR_DFT << " " << DB[index];


		OutFile.close();

	}

}


void MappingAngularDistribution (char* pname, valarray< valarray<int> > &substrate_zenith, valarray< valarray<int> > &substrate_azimuth, int HistoRes) {

	char fname[256];
	strcpy (fname, pname);

	ofstream OutFile; strcat (fname, "AngularDistributionHistogram.txt"); OutFile.open(fname);
	cout << fname << endl;
	strcpy (fname, pname);
	OutFile.precision(6);

	OutFile << "Angle ZenithLMC AzimuthLMC ZenithLTC AzimuthLTC ZenithDFT AzimuthDFT ZenithAll AzimuthAll" << endl;

	valarray<double> substrate_zenith_all(360/HistoRes);
	valarray<double> substrate_azimuth_all(360/HistoRes);

	for (int l = 0; l < 360/HistoRes; l++) {

		substrate_zenith_all[l] = substrate_zenith[0][l] + substrate_zenith[1][l] + substrate_zenith[2][l];
		substrate_azimuth_all[l] = substrate_azimuth[0][l] + substrate_azimuth[1][l] +  substrate_azimuth[2][l];
	}

	for (int l = 0; l < 360/HistoRes; l++) {

		OutFile << (l+1)*HistoRes-(float)HistoRes/2
			<< " " << substrate_zenith[0][l] << " " << substrate_azimuth[0][l]
			<< " " << substrate_zenith[1][l] << " " << substrate_azimuth[1][l]
			<< " " << substrate_zenith[2][l] << " " << substrate_azimuth[2][l]
			<< " " << substrate_zenith_all[l] << " " << substrate_azimuth_all[l] << endl;
	}

	OutFile.close();

}

void MappingPressureDataOutput (char* pname, double virtual_pos[], int virtual_no, double TRflux[], double BSflux[], double TR, double TRH, double BS, double UT, double MFPsampling[], double MFPsectionCount[], double TubeCollCounter[], double CollisionCounter[]) {

	char fname[256];
	TRflux[0] = TRflux[0] + TR +  TRH + BS + UT;

	double *MFPsamplingNorm = new double[virtual_no];
	double *BSfluxNorm = new double[virtual_no];
	double *netflux = new double[virtual_no];

	for (unsigned int l = 0; l < virtual_no; l++) {
		netflux[l] = TRflux[l]-BSflux[l];
	}

	strcpy (fname, pname);
	ofstream OutFile; strcat (fname, "PressureDistribution.txt"); OutFile.open(fname);
	cout << fname << endl;
	OutFile.precision(6);

	OutFile << "Position TRflux BSflux Netflux BSfluxNorm MFPsamplingNorm MFPsectionCount TubeCollCounter CollisionCounter" << endl;

	for (int l = 0; l < virtual_no; l++) {

		if (MFPsectionCount[l] != 0) {
			MFPsamplingNorm[l] = MFPsampling[l]/MFPsectionCount[l];
		}
		else MFPsamplingNorm[l] = 0;

		if (BS != 0) {
			BSfluxNorm[l] = BSflux[l]/BS;
		}
		else BSfluxNorm[l] = 0;

		OutFile << virtual_pos[l] << " " << TRflux[l] << " " << BSflux[l] << " " << netflux[l] << " " << BSfluxNorm[l] << " " << MFPsamplingNorm[l] << " " << MFPsectionCount[l] << " " << TubeCollCounter[l]  << " " << CollisionCounter[l] << endl;
	}

	delete MFPsamplingNorm;
	delete BSfluxNorm;
	delete netflux;

	OutFile.close();
}

void GetConfigurationPlotData(char* pname, double imagesize, double planecenter, double planetilt, double alpha1Array[], double alpha2Array[], double distArray[], int config_num, bool hole, double r_hole, double z_hole, double tilt_hole, double r_a) {

	char fname[256];

	strcpy (fname, pname);
	ofstream OutFile8; strcat (fname, "Configuration.txt"); OutFile8.open(fname);
	strcpy (fname, pname);
	OutFile8.precision(6);

	valarray<double> position_config(3);
	valarray<double> dir_dummy(3);
	dir_dummy[0] = 1;
	dir_dummy[1] = 0;
	dir_dummy[2] = 0;
	for (int i = 0; i < config_num; i++) {

		double alpha1 = alpha1Array[i];
		double alpha2 = alpha2Array[i];
		double dist = distArray[i];

		position_config[0] = 0;
		position_config[1] = 0;
		position_config[2] = 0;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = 1;
		position_config[1] = 0;
		position_config[2] = 0;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = 1;
		position_config[1] = 0;
		position_config[2] = planecenter+tan(degree2rad(planetilt));
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = 0;
		position_config[1] = 0;
		position_config[2] = planecenter;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = -1;
		position_config[1] = 0;
		position_config[2] = planecenter-tan(degree2rad(planetilt));
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = -1;
		position_config[1] = 0;
		position_config[2] = 0;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = r_a;
		position_config[1] = 0;
		position_config[2] = 0;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = r_a;
		position_config[1] = 0;
		position_config[2] = planecenter+r_a*tan(degree2rad(planetilt));
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = 0;
		position_config[1] = 0;
		position_config[2] = planecenter;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = -r_a;
		position_config[1] = 0;
		position_config[2] = planecenter-r_a*tan(degree2rad(planetilt));
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = -r_a;
		position_config[1] = 0;
		position_config[2] = 0;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = 0;
		position_config[1] = 0;
		position_config[2] = 0;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		position_config[0] = 0;
		position_config[1] = 0;
		position_config[2] = planecenter;
		ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
		OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

		OutFile8 << 0 << "  " << 0 << "  " << 0 << endl;
		OutFile8 << -imagesize/2 << "  " << 0 << "  " << 0 << endl;
		OutFile8 << imagesize/2 << "  " << 0 << "  " << 0 << endl;
		OutFile8 << "%" << "  " << "%" << "  " << "%" << endl;

		if (hole != 0) {
			position_config[0] = 0;
			position_config[1] = 0;
			position_config[2] = z_hole;
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = r_a;
			position_config[1] = 0;
			position_config[2] = z_hole+r_a*tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = r_a;
			position_config[1] = 0;
			position_config[2] = z_hole+r_a*tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;


			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))+r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			position_config[0] = 1;
			position_config[1] = 0;
			position_config[2] = z_hole+tan(degree2rad(tilt_hole))-r_hole/cos(degree2rad(tilt_hole));
			ReferenceSystemChange (position_config, dir_dummy, alpha1, alpha2, dist, planecenter, planetilt);
			OutFile8 << position_config[0] << "  " << position_config[1] << "  " << position_config[2] << endl;

			OutFile8 << "%" << "  " << "%" << "  " << "%" << endl;

		}
	}

	OutFile8.close();
}
