#include "ecuyercste1.0.h"
double ran1( int * idum)
/*
Long period (>2*10^18)random number generator of l'Ecuyer with Bays-Durham shuffle and added safeguards.
Return a uniform random deviate between 0.0 and 1.0 (exclusive of the endpoints values).
Call with idum beetween successive deviates in a sequence.
RNMX should approximate the largest floating valuethat is less than 1.
Taken from Numerical Recipes in C

Example:
int * seed;
int nombre =-4644;
seed =& nombre;
*seed = nombre;
R4=ran2(seed);
*/
{
	int j;
	long k;
	static long idum2=123456789;
	static long iy=0;
	static long iv[NTAB];
	double temp;
	if (*idum<=0){//Initialize
		if (-(*idum)<1) *idum=1;//Be sure to prevent idum=0.
		else *idum =-(*idum);
		idum2=(*idum);
		for (j=NTAB+7;j>=0;j--){//Load the shuffle table (after 8 warm-ups). 
			k=(*idum)/IQ1;
			*idum=IA1*(*idum-k*IQ1)-k*IR1;
			if(*idum<0) *idum+=IM1;
			if(j<NTAB) iv[j]= *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ1;//Starts here when not initializing
	*idum=IA1*(*idum-k*IQ1)-k*IR1;//Compute idum=(IA1*idum)%IM1 without overflow  by Schrage's method.
	if (*idum<0) *idum+=IM1;
	k=idum2/IQ2;
	idum2=IA2*(idum2-k*IQ2)-k*IR2;//Compute idum2=(IA2*idum)%IM2 likewise.
	if (idum2<0) idum2+=IM2;
	j=iy/NDIV;//Will be in the range 0..NTAB-1.
	iy=iv[j]-idum2;//Here idum is shuffled, idum and idum2 are combined to generate output.
	iv[j]=*idum;
	if (iy <1)iy+=IMM1;
	if ((temp=AM*iy)>RNMX) return RNMX;//Because users don t except endpoint values.
	else return temp;
}
double ran2( int * idum)
/*
Long period (>2*10^18)random number generator of l'Ecuyer with Bays-Durham shuffle and added safeguards.
Return a uniform random deviate between 0.0 and 1.0 (exclusive of the endpoints values).
Call with idum beetween successive deviates in a sequence.
RNMX should approximate the largest floating valuethat is less than 1.
Taken from Numerical Recipes in C
*/
{
	int j;
	long k;
	static long idum2=123456789;
	static long iy=0;
	static long iv[NTAB];
	double temp;
	if (*idum<=0){//Initialize
		if (-(*idum)<1) *idum=1;//Be sure to prevent idum=0.
		else *idum =-(*idum);
		idum2=(*idum);
		for (j=NTAB+7;j>=0;j--){//Load the shuffle table (after 8 warm-ups). 
			k=(*idum)/IQ1;
			*idum=IA1*(*idum-k*IQ1)-k*IR1;
			if(*idum<0) *idum+=IM1;
			if(j<NTAB) iv[j]= *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ1;//Starts here when not initializing
	*idum=IA1*(*idum-k*IQ1)-k*IR1;//Compute idum=(IA1*idum)%IM1 without overflow  by Schrage's method.
	if (*idum<0) *idum+=IM1;
	k=idum2/IQ2;
	idum2=IA2*(idum2-k*IQ2)-k*IR2;//Compute idum2=(IA2*idum)%IM2 likewise.
	if (idum2<0) idum2+=IM2;
	j=iy/NDIV;//Will be in the range 0..NTAB-1.
	iy=iv[j]-idum2;//Here idum is shuffled, idum and idum2 are combined to generate output.
	iv[j]=*idum;
	if (iy <1)iy+=IMM1;
	if ((temp=AM*iy)>RNMX) return RNMX;//Because users don t except endpoint values.
	else return temp;
}
double ran3( int * idum)
/*
Long period (>2*10^18)random number generator of l'Ecuyer with Bays-Durham shuffle and added safeguards.
Return a uniform random deviate between 0.0 and 1.0 (exclusive of the endpoints values).
Call with idum beetween successive deviates in a sequence.
RNMX should approximate the largest floating valuethat is less than 1.
Taken from Numerical Recipes in C
*/
{
	int j;
	long k;
	static long idum2=123456789;
	static long iy=0;
	static long iv[NTAB];
	double temp;
	if (*idum<=0){//Initialize
		if (-(*idum)<1) *idum=1;//Be sure to prevent idum=0.
		else *idum =-(*idum);
		idum2=(*idum);
		for (j=NTAB+7;j>=0;j--){//Load the shuffle table (after 8 warm-ups). 
			k=(*idum)/IQ1;
			*idum=IA1*(*idum-k*IQ1)-k*IR1;
			if(*idum<0) *idum+=IM1;
			if(j<NTAB) iv[j]= *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ1;//Starts here when not initializing
	*idum=IA1*(*idum-k*IQ1)-k*IR1;//Compute idum=(IA1*idum)%IM1 without overflow  by Schrage's method.
	if (*idum<0) *idum+=IM1;
	k=idum2/IQ2;
	idum2=IA2*(idum2-k*IQ2)-k*IR2;//Compute idum2=(IA2*idum)%IM2 likewise.
	if (idum2<0) idum2+=IM2;
	j=iy/NDIV;//Will be in the range 0..NTAB-1.
	iy=iv[j]-idum2;//Here idum is shuffled, idum and idum2 are combined to generate output.
	iv[j]=*idum;
	if (iy <1)iy+=IMM1;
	if ((temp=AM*iy)>RNMX) return RNMX;//Because users don t except endpoint values.
	else return temp;
}
double ran4( int * idum)
/*
Long period (>2*10^18)random number generator of l'Ecuyer with Bays-Durham shuffle and added safeguards.
Return a uniform random deviate between 0.0 and 1.0 (exclusive of the endpoints values).
Call with idum beetween successive deviates in a sequence.
RNMX should approximate the largest floating valuethat is less than 1.
Taken from Numerical Recipes in C
*/
{
	int j;
	long k;
	static long idum2=123456789;
	static long iy=0;
	static long iv[NTAB];
	double temp;
	if (*idum<=0){//Initialize
		if (-(*idum)<1) *idum=1;//Be sure to prevent idum=0.
		else *idum =-(*idum);
		idum2=(*idum);
		for (j=NTAB+7;j>=0;j--){//Load the shuffle table (after 8 warm-ups). 
			k=(*idum)/IQ1;
			*idum=IA1*(*idum-k*IQ1)-k*IR1;
			if(*idum<0) *idum+=IM1;
			if(j<NTAB) iv[j]= *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ1;//Starts here when not initializing
	*idum=IA1*(*idum-k*IQ1)-k*IR1;//Compute idum=(IA1*idum)%IM1 without overflow  by Schrage's method.
	if (*idum<0) *idum+=IM1;
	k=idum2/IQ2;
	idum2=IA2*(idum2-k*IQ2)-k*IR2;//Compute idum2=(IA2*idum)%IM2 likewise.
	if (idum2<0) idum2+=IM2;
	j=iy/NDIV;//Will be in the range 0..NTAB-1.
	iy=iv[j]-idum2;//Here idum is shuffled, idum and idum2 are combined to generate output.
	iv[j]=*idum;
	if (iy <1)iy+=IMM1;
	if ((temp=AM*iy)>RNMX) return RNMX;//Because users don t except endpoint values.
	else return temp;
}
