// Modules.cpp : Function definition
//

#include "Includes.h"
#include "random.cc"
#include "EcuyerGenerator1.0.cpp"

const double pi = 3.1415926535897932385;
extern int seed1, seed2, seed3, seed4;

inline double frand1 () {

	return double(a_random1(&seed1)); //init surface position and mean free path and uptake
}

inline double frand2 () {

	return double(a_random2(&seed2)); //init surface position and mean free path and uptake
}

inline double frand3 () {

	return double(a_random3(&seed3));  //uniform distribution (used for intermolecular collision)
}

inline double frand4 () {

	return double(a_random4(&seed4)); //cosine distribution 2 (used for init direction)
}

inline void CosDistr (double &angle1, double &angle2) {

	// Uniform distribution of angle
	angle1 = 2*pi*frand1();
	// Cosine distribution of angle2
	angle2 = asin(sqrt(frand1()));

}

inline void CosDistr2 (double &angle1, double &angle2) {

	// Uniform distribution of angle
	angle1 = 2*pi*frand2();
	// Cosine distribution of angle2
	angle2 = asin(sqrt(frand2()));

}

inline void UniDistrFull (double &angle1, double &angle2) {

	// Uniform distribution of angle1
	angle1 = 2*frand3()*pi;
	// Uniform distribution of angle2
	double tmprand = (2*frand3()-1);
	angle2 = acos(tmprand);

}

inline void UniDistrHalf (double &angle1, double &angle2) {

	// Uniform distribution of angle1
	angle1 = 2*frand4()*pi;
	// Uniform distribution of angle2
	angle2 = acos(frand4());

}

double degree2rad(double angle_degree) {

	return angle_degree/180*pi;
}

inline double rad2degree(double angle_rad) {

	return angle_rad/pi*180;
}

void mInit(valarray< valarray< valarray<int> > > &m, int mSize_x, int mSize_y) {

	int thirddim(30);
	m.resize (thirddim);
	for (int k = 0; k < thirddim; k++) {
		m[k].resize (mSize_x);
		for (unsigned int i = 0; i < m[k].size(); i++) {
			m[k][i].resize (mSize_y);
			for (unsigned int j = 0; j < m[k][i].size(); j++)
				m[k][i][j] = 0;
		}
	}
}

void Pause () {

	for (int i = 0; i < 1e12; i++) {}
}

void MolInit (valarray<double> &pos, valarray<double> &dir, double &path_tot, double &path, double MFP_mean, double &MFP) {

	path_tot = 0;
	path = 0;

	//random start position on the tube entrance surface
	double x_pos = (2*frand1()-1);
	double y_pos = (2*frand1()-1);
	while (x_pos*x_pos + y_pos*y_pos > 1) {
		x_pos = (2*frand1()-1);
		y_pos = (2*frand1()-1);
	}

	pos[0] = x_pos;
	pos[1] = y_pos;
	pos[2] = 0;

	//cosine distributed direction
	double phi;
	double theta;
	CosDistr2(phi, theta);

	dir[0] = sin(theta)*cos(phi);
	dir[1] = sin(theta)*sin(phi);
	dir[2] = cos(theta);

	//first Mean Free Path (MFP)
	double tmprand = frand2();
	while (tmprand == 0) tmprand = frand2(); //avoid division by 0!
	MFP = MFP_mean*log(1/tmprand);
	//uniform distribution
	//MFP = MFP*frand2();
}

void MolTube (valarray<double> &pos, valarray<double> &dir, valarray<double> &dir_new, double &path_tot, double &path) {

	double T;
	double a;
	double b;
	double c;
	double d;

	//computes Mol strike on an infinitely long tube
	a = dir[0]*dir[0]+dir[1]*dir[1];
	if (a == 0) {
		T = 1000;
		b = 0; c = 0; d = 0;
	}
	else {
		b = 2*(pos[0]*dir[0]+pos[1]*dir[1]);
		c = pos[0]*pos[0] + pos[1]*pos[1] - 1;
		d = b*b - 4*a*c;

		if (d < 0) {
			cout << "Error in MolTube!!! a = " << a << ", b =" << b  << ", c =" << c  << ", d =" << d << endl;
			cout << pos[0] << " " << pos[1] << " " << pos[2] << endl;
			cout << dir[0] << " " << dir[1] << " " << dir[2] << endl << endl;
		}

		T = (-b + sqrt(d))/(2*a);
	}

	//Update of collision position on tube wall
	pos = pos + T*dir;

	//Update of Mol path length
	path_tot = path_tot + T;
	path = path + T;

	//Update of direction from tube wall
	//Cosine distributed direction
	double phi;
	double theta;

	// Cosine or "uniform" desorption
	CosDistr(phi, theta);
//	UniDistrHalf(phi, theta);
	dir_new[0] = -pos[0]*cos(theta) + pos[1]*sin(theta)*sin(phi);
	dir_new[1] = -pos[0]*sin(theta)*sin(phi) - pos[1]*cos(theta);
	dir_new[2] = sin(theta)*cos(phi);

/*
	//Mixed cosine desorption and specular reflection
	if(frand3() >= 0.9) {
		//	Specular reflection
		dir_new[0] = dir[0] - pos[0]*2*(pos[0]*dir[0]+pos[1]*dir[1]);
		dir_new[1] = dir[1] - pos[1]*2*(pos[0]*dir[0]+pos[1]*dir[1]);
		dir_new[2] = dir[2];
	}
	else {
		CosDistr(phi, theta);
		//UniDistrHalf(phi, theta);
		dir_new[0] = -pos[0]*cos(theta) + pos[1]*sin(theta)*sin(phi);
		dir_new[1] = -pos[0]*sin(theta)*sin(phi) - pos[1]*cos(theta);
		dir_new[2] = sin(theta)*cos(phi);
	}
*/
}


void MFP_adapt(double &MFP, double MFP_mean, double &path,
			   valarray<double> &pos, valarray<double> &pos_old, double virtual_pos[], int virtual_no,
			   double MFPsampling[], double MFPsectionCount[], valarray<double> &dir,
			   double planecenter, double planetilt, double DeltaP) {

	valarray<double> pos_tmp = pos;
	double path_tmp = path;
	double MFP_old = MFP;

	//Rotation angle
	double angle_rot = degree2rad(planetilt);

	//molecule leaves tube at entrance
	if (pos[2] < 0) {
		//set pos_tmp to intersection point with the tube entrance surface
		pos_tmp = pos - pos[2]/dir[2]*dir;
		pos_tmp[2] = 0;
		//adapt path_tmp up to tube inlet
		path_tmp = path - pos[2]/dir[2];
	}
	//molecule leaves tube at exit
	else if (pos[2] > planecenter-tan(angle_rot)) {  //checks the minimum z value where the tube cut begins
		double sinangle_rot = sin(angle_rot);
		if (abs(sinangle_rot) < 1e-15) sinangle_rot = 0;
		double n[] = {-sinangle_rot, 0, cos(angle_rot)}; //rotation of the n=0,0,1 by planetilt
		double a[] = {0, 0, planecenter};
		double t = (n[0]*pos[0]+n[1]*pos[1]+n[2]*pos[2]-(n[0]*a[0]+n[1]*a[1]+n[2]*a[2]))/(n[0]*dir[0]+n[1]*dir[1]+n[2]*dir[2]);
		if (sqrt((pos[0]-t*dir[0])*(pos[0]-t*dir[0])+(pos[1]-t*dir[1])*(pos[1]-t*dir[1])) <= 1) {
			//set pos_tmp to intersection point with the tube exit
			pos_tmp = pos - t*dir; //position on the tilted exit surface
			//adapt path_tmp up to tube exit
			path_tmp = path - sqrt((pos_tmp[0]-pos[0])*(pos_tmp[0]-pos[0])+(pos_tmp[1]-pos[1])*(pos_tmp[1]-pos[1])+(pos_tmp[2]-pos[2])*(pos_tmp[2]-pos[2]));
		}
	}

	if (path_tmp > MFP) {
		pos_tmp = pos_tmp - (path_tmp - MFP)*dir;
	}

	double y0 = 1;
	double Pslope = - DeltaP/planecenter/100;
	double PressureDecay;
	double s = sqrt((pos_tmp[0]-pos_old[0])*(pos_tmp[0]-pos_old[0])+(pos_tmp[1]-pos_old[1])*(pos_tmp[1]-pos_old[1])+(pos_tmp[2]-pos_old[2])*(pos_tmp[2]-pos_old[2]));
	//linear pressure decay by DeltaP
	PressureDecay = y0 + Pslope*(pos_tmp[2]+pos_old[2])/2;

	//MFP adaption via pressure decay
	if (pos_tmp[2]-pos_old[2] >= 0) MFP = MFP_old + s*(1/PressureDecay-1);
	else {
		MFP = MFP_old + s*(PressureDecay-1);
	}

	//	Sampling of the simulated molecule mean free path inside the tube

	//Actual mean free path is attributed to the section in the middle of the traveled path
	int Ind_tmp = floor(((pos_tmp[2]+pos_old[2])/2)/planecenter*virtual_no);
}

bool MolMol (valarray<double> &pos, valarray<double> &dir, valarray<double> &dir_new, double &path_tot, double &path, double MFP_mean, double &MFP, double planecenter) {

	bool checkit = false;

	//Checks for molecular collision
	if (path > MFP) {
		checkit = true;
		//Update of collision position and path
		pos = pos - (path - MFP)*dir;
		path_tot = path_tot - (path - MFP);
		path = 0;

		//Update of direction after molecular collision
		//Uniform distributed direction into full sphere
		double phi;
		double theta;
		UniDistrFull(phi, theta);

		dir_new[0] = sin(theta)*cos(phi);
		dir_new[1] = sin(theta)*sin(phi);
		dir_new[2] = cos(theta);

		//New MFP
		double tmprand = frand2();
		while (tmprand == 0) tmprand = frand2(); //avoid division by 0!
		MFP = MFP_mean*log(1/frand2());

	}

	return checkit;
}

bool MolMol_pressure_decay (valarray<double> &pos, valarray<double> &dir, valarray<double> &dir_new, double &path_tot, double &path, double MFP_mean, double &MFP, double planecenter, double DeltaP) {

	bool checkit = false;

	//Checks for molecular collision
	if (path > MFP) {
		checkit = true;
		//Update of collision position and path
		pos = pos - (path - MFP)*dir;
		path_tot = path_tot - (path - MFP);
		path = 0;

		//Update of direction after molecular collision
		//Uniform distributed direction into full sphere
		double phi;
		double theta;
		UniDistrFull(phi, theta);

		dir_new[0] = sin(theta)*cos(phi);
		dir_new[1] = sin(theta)*sin(phi);
		dir_new[2] = cos(theta);

		//New MFP
		double tmprand = frand2();
		while (tmprand == 0) tmprand = frand2(); //avoid division by 0!
		MFP = MFP_mean/(1-DeltaP/100*pos[2]/planecenter)*log(1/tmprand);

	}

	return checkit;
}

bool MolTransTubeEnd (valarray<double> &pos, valarray<double> &dir, double &path_tot, double planecenter, double planetilt) {

	bool checkit = false;
	valarray<double> pos_tmp(3);

	//Rotation angle
	double angle_rot = degree2rad(planetilt);

	double sinangle_rot = sin(angle_rot);
	if (abs(sinangle_rot) < 1e-15) sinangle_rot = 0;

	double n[] = {-sinangle_rot, 0, cos(angle_rot)}; //rotation of the n=0,0,1 by planetilt
	double a[] = {0, 0, planecenter};

	double t = (n[0]*pos[0]+n[1]*pos[1]+n[2]*pos[2]-(n[0]*a[0]+n[1]*a[1]+n[2]*a[2]))/(n[0]*dir[0]+n[1]*dir[1]+n[2]*dir[2]);

	//Checks if the molecule has left the tube exit
	if (pos[2] > planecenter-tan(angle_rot)) {  //checks the minimum z value where the tube cut begins

		if (sqrt((pos[0]-t*dir[0])*(pos[0]-t*dir[0])+(pos[1]-t*dir[1])*(pos[1]-t*dir[1])) <= 1) {
			checkit = true;

			pos_tmp = pos;

			//Update of position on tube exit surface and path_tot (using the new interaction position and the old direction)
			//pos = pos + (planecenter - pos[2])/dir[2]*dir; //the molecule has left the tube, the fct SubstrateStrike assumes the exit position on the no tilted exit surface
			pos = pos_tmp - t*dir; //position on the tilted exit surface (fct SubstrateStrike must be adapted)

			//path_tot until tube or molecule collision position, pos_tmp, substracted by distance outside of tube |pos_tmp-pos|
			path_tot = path_tot - sqrt((pos_tmp[0]-pos[0])*(pos_tmp[0]-pos[0])+(pos_tmp[1]-pos[1])*(pos_tmp[1]-pos[1])+(pos_tmp[2]-pos[2])*(pos_tmp[2]-pos[2]));
		}
	}
	return checkit;
}

bool MolTransHole (valarray<double> &pos, double z_hole, double tilt_hole, double r_hole, double TC_hole) {

	bool checkit = false;

	//Checks if the molecule leaves through hole
	if (pos[0] > 0) {

		valarray<double> pos_tmp(3);

		//Coordinate system change
		//Rotation angle
		double angle_rot = degree2rad(tilt_hole);

		double sinangle_rot = sin(angle_rot);
		if (abs(sinangle_rot) < 1e-15) sinangle_rot = 0;

		//translation of coordinate system along z by -z_hole
		//and rotation of coordinate system around y by tilt_hole
		pos_tmp[0] = pos[0]*cos(angle_rot) + (pos[2]-z_hole)*sinangle_rot;
		pos_tmp[1] = pos[1];
		pos_tmp[2] = -pos[0]*sinangle_rot + (pos[2]-z_hole)*cos(angle_rot);

		if (sqrt(pos_tmp[1]*pos_tmp[1] + pos_tmp[2]*pos_tmp[2]) <= r_hole) {

			if (TC_hole > frand4()) {
				checkit = true;
			}
		}
	}

	return checkit;
}

bool MolBack (valarray<double> &pos, valarray<double> &dir) {

	bool checkit = false;

	//Checks if the molecule has left the tube entry
	if (pos[2] < 0) {
		checkit = true;
		//position on tube entrance surface
		pos = pos - pos[2]/dir[2]*dir;
		pos[2] = 0;
	}

	return checkit;
}

bool MolUptake (double uptakecoeff) {

	//Checks if the molecule sticks to the tube wall
	bool Uptake = uptakecoeff > frand2();

	return Uptake;
}


void ReferenceSystemChange (valarray<double> &pos, valarray<double> &dir, double &angle1, double &angle2, double dist, double planecenter, double planetilt) {

	valarray<double> pos_tmp1(3);
	valarray<double> pos_tmp2(3);
	valarray<double> dir_tmp1(3);
	valarray<double> dir_tmp2(3);

	//Coordinate system change
	//Rotation angle
	double angle_rot1 = degree2rad(planetilt+angle1);
	double sinangle_rot1 = sin(angle_rot1);
	if (abs(sinangle_rot1) < 1e-15) sinangle_rot1 = 0;

	//Coordinate system change
	//Rotation angle
	//double angle_rot2 = 3*pi/2 - degree2rad(angle) - degree2rad(planetilt); //on-axis distance between tube exit surface and substrate
	double angle_rot2 = pi + degree2rad(angle2);
	double sinangle_rot2 = sin(angle_rot2);
	if (abs(sinangle_rot2) < 1e-15) sinangle_rot2 = 0;

	double dist_tmp = dist; //distance between tube center and origin along the extension defined by the angle from the tube exit surface normal: angle1

	// translation of coordinate system to exit surface center
	pos_tmp2[0] = pos[0];
	pos_tmp2[1] = pos[1];
	pos_tmp2[2] = pos[2]-planecenter;

	// rotation of coordinate system around y -> z normal to exit plane
	// and translation of coordinate system along z by -dist_tmp
	pos_tmp1[0] = pos_tmp2[0]*cos(angle_rot1) + pos_tmp2[2]*sinangle_rot1;
	pos_tmp1[1] = pos_tmp2[1];
	pos_tmp1[2] = -pos_tmp2[0]*sinangle_rot1 + pos_tmp2[2]*cos(angle_rot1) - dist_tmp;
	dir_tmp1[0] = dir[0]*cos(angle_rot1) + dir[2]*sinangle_rot1;
	dir_tmp1[1] = dir[1];
	dir_tmp1[2] = -dir[0]*sinangle_rot1 + dir[2]*cos(angle_rot1);

	// rotation of coordinate system around y -> z normal to substrate plane
	// and rotation of coordinate system around z -> x from right to left
	pos_tmp2[0] = - (pos_tmp1[0]*cos(angle_rot2) + pos_tmp1[2]*sinangle_rot2);
	pos_tmp2[1] = - (pos_tmp1[1]);
	pos_tmp2[2] = -pos_tmp1[0]*sinangle_rot2 + pos_tmp1[2]*cos(angle_rot2);
	dir_tmp2[0] = - (dir_tmp1[0]*cos(angle_rot2) + dir_tmp1[2]*sinangle_rot2);
	dir_tmp2[1] = - (dir_tmp1[1]);
	dir_tmp2[2] = -dir_tmp1[0]*sinangle_rot2 + dir_tmp1[2]*cos(angle_rot2);

	pos = pos_tmp2;
	dir = dir_tmp2;
}


bool SubstrateStrike (valarray<double> &pos, valarray<double> &dir, valarray<double> &pos_substrate, valarray<double> &dir_substrate, double &path_tot, double &angle1, double &angle2, double dist, double planecenter, double planetilt) {

	bool checkit = false;
	valarray<double> pos_tmp = pos;
	valarray<double> dir_tmp = dir;

	ReferenceSystemChange (pos_tmp, dir_tmp, angle1, angle2, dist, planecenter, planetilt);

	//Molecule is not lost in space if...
	if (-pos_tmp[2]/dir_tmp[2] >= -1e-12) {
		checkit = true;
		//Strike position (implicit: z = 0) on the substrate
		pos_substrate = pos_tmp - pos_tmp[2]/dir_tmp[2]*dir_tmp;
		dir_substrate = dir_tmp;
		path_tot = path_tot + pos_tmp[2]/dir_tmp[2];
	}

/*	/////////////////////// shadowing/////////////////////////

	valarray<double> pos_yz(3);
	valarray<double> pos_xz1(3);
	valarray<double> pos_xz2(3);
	valarray<double> pos_xy(3);
	double halfwidth = 0.00476;
	double height = 0.0476;
	double Dx = 0.0;

	pos_yz = pos_tmp2 - (pos_tmp2[0]+halfwidth+Dx)/dir_tmp2[0]*dir_tmp2;
	pos_xz1 = pos_tmp2 - (pos_tmp2[1]+halfwidth)/dir_tmp2[1]*dir_tmp2;
	pos_xz2 = pos_tmp2 - (pos_tmp2[1]-halfwidth)/dir_tmp2[1]*dir_tmp2;
	pos_xy = pos_tmp2 - (pos_tmp2[2]-height)/dir_tmp2[2]*dir_tmp2;

	//Molecule hits obstacle
	if	(abs(pos_yz[1]) < halfwidth && pos_yz[2] < height && pos_yz[2] > 0) {
		checkit = false;
	}
	else if (abs(pos_xz1[0]+Dx) < halfwidth && pos_xz1[2] < height && pos_xz1[2] > 0
		|| abs(pos_xz2[0]+Dx) < halfwidth && pos_xz2[2] < height && pos_xz2[2] > 0) {
		checkit = false;
	}
	else if (abs(pos_xy[0]+Dx) < halfwidth && abs(pos_xy[1]) < halfwidth) {
		checkit = false;
	}
*/
	//////////////////////////////////////////////////////////

	return checkit;
}


void MolPressure (valarray<double> &pos, valarray<double> &pos_old, double virtual_pos[], int virtual_no, double TRflux[], double BSflux[]) {

	if (pos_old[2] - pos[2] > 0) {
		for (unsigned int k = 0; k < virtual_no; k++) {
			if (virtual_pos[k] >= pos[2] && virtual_pos[k] < pos_old[2]) {
				BSflux[k]++;
			}
		}
	}
	else {
		for (unsigned int k = 0; k < virtual_no; k++) {
			if (virtual_pos[k] <= pos[2] && virtual_pos[k] > pos_old[2]) {
				TRflux[k]++;
			}
		}
	}
}

void Desorption_Back (valarray<double> &pos_sub, valarray<double> &DB, double &angle1, double &angle2, double dist, double planecenter, double planetilt, int &index) {

	valarray<double> c_sub(3);
	valarray<double> n_sub(3);
	valarray<double> d_sub(3);

	valarray<double> dir_dummy(3);
	dir_dummy[0] = 1;
	dir_dummy[1] = 0;
	dir_dummy[2] = 0;

	//get tube exit surface center in substrate coordinates
	c_sub[0] = 0;
	c_sub[1] = 0;
	c_sub[2] = planecenter;
	ReferenceSystemChange (c_sub, dir_dummy, angle1, angle2, dist, planecenter, planetilt);

	//get tube exit surface center in substrate coordinates
	n_sub[0] = -sin(degree2rad(planetilt));
	n_sub[1] = 0;
	n_sub[2] = planecenter+cos(degree2rad(planetilt));
	ReferenceSystemChange (n_sub, dir_dummy, angle1, angle2, dist, planecenter, planetilt);
	n_sub = n_sub - c_sub;

	//Desorption direction from substrate
	//Cosine distributed direction
	double phi;
	double theta;
	CosDistr(phi, theta);

	d_sub[0] = sin(theta)*cos(phi);
	d_sub[1] = sin(theta)*sin(phi);
	d_sub[2] = cos(theta);

	double k_sub = (n_sub[0]*c_sub[0]+n_sub[1]*c_sub[1]+n_sub[2]*c_sub[2] - (n_sub[0]*pos_sub[0]+n_sub[1]*pos_sub[1]+n_sub[2]*pos_sub[2]))/(n_sub[0]*d_sub[0]+n_sub[1]*d_sub[1]+n_sub[2]*d_sub[2]);
	double c_dist = sqrt((pos_sub[0]+k_sub*d_sub[0]-c_sub[0])*(pos_sub[0]+k_sub*d_sub[0]-c_sub[0])+(pos_sub[1]+k_sub*d_sub[1]-c_sub[1])*(pos_sub[1]+k_sub*d_sub[1]-c_sub[1])+(pos_sub[2]+k_sub*d_sub[2]-c_sub[2])*(pos_sub[2]+k_sub*d_sub[2]-c_sub[2]));
	// valid only for spherical exit area (if planetilt = 0)
	if (c_dist <= 1.0) {
			DB[index]++;
	}
}
